@extends('admin.layout.master')

@section('content')
    <div class="row">
        <div class="col-md-12 ">
            <ol class="breadcrumb">
                <li><a href="{{route('admin.home')}}">صفحه اصلی</a></li>
                <li><a href="{{route('admin.service.cardstatus.index')}}">لیست وضعیت کارت ها</a></li>
                <li class="active">ایجاد وضعیت کارت</li>
            </ol>
        </div>
    </div>

    <form method="post" action="{{route('admin.service.cardstatus.store')}}">
        {{ csrf_field() }}
        <div class="row white z-depth-1">
            <div class="col-md-12">
                <span class="blue-grey darken-2 white-text title z-depth-2">ایجاد وضعیت کارت</span>
                @include('share.extra.back2',['route'=>route('admin.service.cardstatus.index')])
            </div>

            <div class="col-md-12 mb20">
                <label for="cards">انتخاب کارت</label>
                <multiselect id="cards" v-model="serviceCard.selected" :options="serviceCard.list" @search-change="search($event,'serviceCard')" :custom-label="customLabel" :multiple="false" :close-on-select="true" track-by="id" :internal-search="false">
                    <span v-if="serviceCard.list.length > 0 && isMoreResult('serviceCard')"  @click="moreResult('serviceCard')" class="waves-effect waves-light btn quarter center-block teal darken-2 mt20" slot="afterList">
                        <span v-if="serviceCard.loading"><i class="fa fa-spinner fa-pulse fa-3x fa-fw"></i></span>
                        <span v-else>موارد بیشتر</span>
                    </span>
                </multiselect>
                @include('share.forms.error',['name'=>'skill_id'])
            </div>

            <div class="col-md-6">
                @include('share.forms.input',['name'=>'title','title'=>'تیتر'])
            </div>
            <div class="col-md-6 mt35">
                @include('share.forms.switch',['name'=>'status','title'=>'وضعیت','checked'=>true])
            </div>

            <div>
                <input type="hidden" id="card_id" name="card_id">
            </div>

            <div class="col-md-12 mb20 mt20 ">
                <button class="waves-effect waves-light btn quarter center-block blue-grey darken-2">ذخیره</button>
            </div>

        </div>
    </form>
@endsection


@push('scripts')
    <script src="{{asset('assets/plugins/vueselect/vueselect.js')}}"></script>

    <script>
        $(document).ready(function () {
            $('select').material_select();
        });

        Vue.component('Multiselect', VueMultiselect.default);
        new Vue({
            el:'#app',
            data:{
                ax:axios.create({baseURL: baseUrl,headers:{'Authorization':'Bearer {{auth()->user()->api_token}}'}}),

                serviceCard:{
                    url:'/admin/v1/service/card',
                    list:[],
                    selected:[],
                    query:'',
                    params:{},
                    data:[],
                    loading:false
                },
            },
            created: function () {
                this.search(null, 'serviceCard');
            },
            methods:{
                search: function (query, field, extraQuery = {}) {
                    this[field].params = extraQuery;
                    if (query) {
                        this[field].params.query = query;
                    }

                    if (query !== '' || query === null) {
                        this.ax.get(this[field].url, {params: this[field].params}).then(function (response) {
                            this[field].query = query;
                            this[field].list = response.data.data;
                            this[field].data = response.data;
                        }.bind(this));
                    }
                },
                customLabel: function (element) {
                    return element.id + ' - ' + element.title;
                },
                isMoreResult: function (field) {
                    return (this[field].data.current_page + 1 <= this[field].data.last_page);
                },
                moreResult: function (field) {
                    if (this.isMoreResult(field)) {
                        this[field].loading = true;
                        this[field].params.page = this[field].data.current_page + 1;

                        this.ax.get(this[field].url, {params: this[field].params}).then(function (response) {
                            this[field].list = this[field].list.concat(response.data.data);
                            this[field].data = response.data;
                            this[field].loading = false;
                        }.bind(this));
                    }
                }
            },
            watch:{
                'serviceCard.selected': function () {
                    if (this.serviceCard.selected) {
                        document.getElementById('card_id').value = this.serviceCard.selected.id;
                    } else {
                        document.getElementById('card_id').value = null;
                    }
                },
            }
        });
    </script>

@endpush

@push('styles')
    <link rel="stylesheet" href="{{asset('assets/plugins/vueselect/vueselect.css')}}">
@endpush

