@extends('admin.layout.master')

@section('content')
    <div class="row">
        <div class="col-md-12 ">
            <ol class="breadcrumb">
                <li><a href="{{route('admin.home')}}">صفحه اصلی</a></li>
                <li><a href="{{route('admin.service.offer.index')}}">لیست آفر خدمات</a></li>
                <li class="active">ویرایش آفر</li>
            </ol>
        </div>
    </div>

    <form method="post" action="{{route('admin.service.offer.update',$serviceOffer->id)}}" enctype="multipart/form-data">
        {{ method_field('PUT') }}
        {{ csrf_field() }}
        <div class="row white z-depth-1">
            <div class="col-md-12">
                <span class="blue-grey darken-2 white-text title z-depth-2">ویرایش آفر خدمات</span>
                @include('share.extra.back2',['route'=>route('admin.service.offer.index')])
            </div>

            <div class="col-md-12 mb20">
                <label for="categories">انتخاب دسته بندی</label>
                <multiselect id="categories" v-model="category.selected" :options="category.list" @search-change="search($event,'category')" :custom-label="customLabel" :multiple="true" :close-on-select="false" track-by="id" :internal-search="false">
                        <span v-if="category.list.length > 0 && isMoreResult('category')"  @click="moreResult('category')" class="waves-effect waves-light btn quarter center-block teal darken-2 mt20" slot="afterList">
                            <span v-if="category.loading"><i class="fa fa-spinner fa-pulse fa-3x fa-fw"></i></span>
                            <span v-else>موارد بیشتر</span>
                        </span>
                </multiselect>
                @include('share.forms.error',['name'=>'department_id'])
            </div>
            <div class="col-md-6">
                @include('share.forms.input',['name'=>'title','title'=>'تیتر','value'=>$serviceOffer->title])
            </div>
            <div class="col-md-6">
                @include('share.forms.input',['name'=>'code','class'=>'dleft','title'=>'کد تخفیف','value'=>$serviceOffer->code])
            </div>
            <div class="clearfix"></div>

            <div class="col-md-6">
                @include('share.forms.select',['name'=>'type','title'=>'نوع','options'=>['offer'=>'تخفیف','service'=>'خدمات'],'selected'=>$serviceOffer->type])
            </div>
            <div class="col-md-6">
                @include('share.forms.input',['name'=>'link','class'=>'dleft','title'=>'لینک','value'=>$serviceOffer->link])
            </div>
            <div class="clearfix"></div>

            <div class="col-md-12">
                @include('share.forms.textarea-Material',['name'=>'body','title'=>'توضیحات','value'=>$serviceOffer->body])
            </div>
            <div class="clearfix mb20"></div>

            <div class="col-md-6">
                @include('share.forms.date',['name'=>'expire','class'=>'dleft','title'=>'تاریخ انقضا','disabled'=>false])
            </div>
            <div class="clearfix mb20"></div>

            <div class="col-md-6">
                @include('share.forms.file',['name'=>'picture','title'=>'عکس'])
            </div>
            <div class="col-md-6 mt30">
                @include('share.forms.switch',['name'=>'status','title'=>'فعال','checked'=>$serviceOffer->status])
            </div>
            <div class="clearfix"></div>

            @if($serviceOffer->picture)
                <div class="col-md-6">
                    <img src="{{asset($serviceOffer->picture)}}" class="img-raised hg100" alt="">
                </div>
            @endif

            <div>
                <input type="hidden" id="category_id" name="category_id" value="{{$serviceOffer->category->pluck('id')}}">
            </div>



            <div class="col-md-12 mb20 mt20 ">
                <button class="waves-effect waves-light btn quarter center-block blue darken-1">ذخیره</button>
            </div>

        </div>
    </form>
@endsection

@push('scripts')
    <script src="{{asset('assets/plugins/datePicker/persianDate.js')}}"></script>
    <script src="{{asset('assets/plugins/datePicker/datePicker.js')}}"></script>
    <script src="{{asset('assets/plugins/vueselect/vueselect.js')}}"></script>

    <script>
        $(document).ready(function () {
            $("#expire").pDatepicker({
                format: "YYYY/MM/DD HH:mm:ss",
                initialValueType: 'gregorian',
                timePicker: {
                    enabled: true,
                    meridiem: {
                        enabled: true
                    }
                }
            });
            $("#expire").val('{{toPersian($serviceOffer->expire,'Y/m/d H:i:s')}}')

            $('select').material_select();
        });

        Vue.component('Multiselect', VueMultiselect.default);
        new Vue({
            el:'#app',
            data:{
                ax:axios.create({baseURL: baseUrl,headers:{'Authorization':'Bearer {{auth()->user()->api_token}}'}}),

                category:{
                    url:'/admin/v1/service/category',
                    list:[{!! $serviceOffer->category !!}],
                    selected:{!! $serviceOffer->category !!},
                    query:'',
                    params:{},
                    data:[],
                    loading:false
                },
            },
            created: function () {
                this.search(null, 'category');
            },
            methods:{
                search: function (query, field, extraQuery = {}) {
                    this[field].params = extraQuery;
                    if (query) {
                        this[field].params.query = query;
                    }

                    if (query !== '' || query === null) {
                        this.ax.get(this[field].url, {params: this[field].params}).then(function (response) {
                            this[field].query = query;
                            this[field].list = response.data.data;
                            this[field].data = response.data;
                        }.bind(this));
                    }
                },
                customLabel: function (element) {
                    return element.id + ' - ' + element.title;
                },
                isMoreResult: function (field) {
                    return (this[field].data.current_page + 1 <= this[field].data.last_page);
                },
                moreResult: function (field) {
                    if (this.isMoreResult(field)) {
                        this[field].loading = true;
                        this[field].params.page = this[field].data.current_page + 1;

                        this.ax.get(this[field].url, {params: this[field].params}).then(function (response) {
                            this[field].list = this[field].list.concat(response.data.data);
                            this[field].data = response.data;
                            this[field].loading = false;
                        }.bind(this));
                    }
                }
            },
            watch:{
                'category.selected': function () {
                    var output = [];
                    for (var i = 0; i < this.category.selected.length; i++) {
                        output.push(this.category.selected[i]['id']);
                    }
                    document.getElementById('category_id').value = JSON.stringify(output);
                },
            }
        });
    </script>

@endpush

@push('styles')
    <link rel="stylesheet" href="{{asset('assets/plugins/vueselect/vueselect.css')}}">
    <link rel="stylesheet" href="{{asset('assets/plugins/datePicker/persianDatePicker.css')}}">
    <link rel="stylesheet" href="{{asset('assets/plugins/datePicker/custom.css')}}" />
@endpush
