@extends('admin.layout.master')

@section('content')
    <form method="post" action="{{route('admin.settingcategory.update',$settingcategory->id)}}">
        {{ csrf_field() }}
        {{ method_field('PUT') }}
        <div class="row white z-depth-1">
            <div class="col-md-12">
                <span class="blue-grey darken-2 white-text title z-depth-2">ویرایش دسته بندی تنظیمات</span>
                @include('share.extra.back2',['route'=>route('admin.settingcategory.index')])
            </div>

            <div class="col-md-6">
                @include('share.forms.input',['name'=>'title','title'=>'تیتر','value'=>$settingcategory->title])
            </div>
            <div class="col-md-6">
                @include('share.forms.input',['name'=>'order','title'=>'موقعیت','class'=>'dleft','value'=>$settingcategory->order])
            </div>
            <div class="clearfix"></div>
            <div class="col-md-6 mt20">
                @include('share.forms.switch',['name'=>'status','title'=>'فعال','checked'=>$settingcategory->status])
            </div>

            <div class="col-md-12 mb20 mt20 ">
                <button class="waves-effect waves-light btn quarter center-block blue-grey darken-2">ویرایش</button>
            </div>
        </div>
    </form>
@endsection

@push('scripts')
    <script>
        $(document).ready(function() {
            $('select').material_select();
        });
    </script>
@endpush
