@extends('admin.layout.master')

@section('content')
    <form method="post" action="{{route('admin.settings.store')}}" enctype="multipart/form-data">
        {{ csrf_field() }}
        <div class="row white z-depth-1">

            <div class="col-md-12 pd4">
                <div class="col-md-12 pd0 mb10">
                    <ul class="tabs blue-grey darken-2 z-depth-2">
                        @foreach($list as $category)
                            @if($loop->first)
                                <li class="tab"><a class="active" href="#test{{$loop->index}}">{{$category->title}}</a></li>
                            @else
                                <li class="tab"><a href="#test{{$loop->index}}">{{$category->title}}</a></li>
                            @endif
                        @endforeach
                    </ul>
                </div>
            </div>

            @foreach($list as $category)
                <div id="test{{$loop->index}}" class="col s12">
                    @foreach($category->settingsAdmin as $key => $value)

                        @if($value->type == 'string')
                            @if($value->linkable)
                                <div class="col-md-12 pd4 mt20">
                                    <div class="col-md-6">
                                        {!! view('share.forms.input',
                                        ['name' => "string[$value->id][value]", 'title' => $value->title,'value'=>isset($value->settings->value)?$value->settings->value:'']) !!}
                                    </div>
                                    <div class="col-md-6">
                                        {!! view('share.forms.input',
                                       ['name' => "string[$value->id][link]", 'title' => 'لینک','value'=>isset($value->settings->link)?$value->settings->link:'']) !!}
                                    </div>
                                </div>
                            @else
                                <div class="col-md-12 mt20">
                                    {!! view('share.forms.input',
                                    ['name' => "string[$value->id][value]", 'title' => $value->title,'value'=>isset($value->settings->value)?$value->settings->value:'']) !!}
                                </div>
                            @endif
                        @endif

                        @if($value->type == 'boolean')
                            <div class="col-md-6 mt20">
                                {!! view('share.forms.switch',
                                ['name' => "boolean[$value->id][value]", 'title' => $value->title,'checked'=>isset($value->settings->value)?$value->settings->value:0]) !!}
                            </div>
                        @endif

                        @if($value->type == 'article')
                            <div class="col-md-12 mt20">
                                <label for="article{{$value->id}}">{{$value->title}}</label>
                                <select id="article{{$value->id}}" name="article[{{$value->id}}][value][]"
                                        multiple="multiple" class="article">
                                    @if(isset($value->settings->value))
                                        @foreach(\cms\article\Models\article::whereIn('id',json_decode($value->settings->value))->get() as $article)
                                            <option selected="selected"
                                                    value="{{$article->id}}">{{$article->title}}</option>
                                        @endforeach
                                    @endif
                                </select>
                            </div>
                        @endif

                        @if($value->type == 'product')
                            <div class="col-md-12 mt20">
                                <label for="product{{$value->id}}">{{$value->title}}</label>
                                <select id="product{{$value->id}}" name="product[{{$value->id}}][value][]"
                                        multiple="multiple" class="product">
                                    @if(isset($value->settings->value))
                                        @foreach(\cms\product\Models\Product\product::whereIn('id',json_decode($value->settings->value))->get() as $product)
                                            <option selected="selected"
                                                    value="{{$product->id}}">{{$product->title}}</option>
                                        @endforeach
                                    @endif
                                </select>
                            </div>
                        @endif

                        @if($value->type == 'textarea')
                            <div class="col-md-12 mt20">
                                {!! view('share.forms.textarea-Material',
                                ['name' => "textarea[$value->id][value]", 'title' => $value->title,'value'=>isset($value->settings->value)?$value->settings->value:'']) !!}
                            </div>
                        @endif

                        @if($value->type == 'editor')
                            <div class="col-md-12 mt20">
                                <label>{{$value->title}}</label>
                                {!! view('share.forms.textarea',
                                ['name' => "editor[$value->id][value]", 'title' => $value->title,'class'=>'editor','value'=>isset($value->settings->value)?$value->settings->value:'']) !!}
                            </div>
                        @endif

                        @if($value->type == 'file')
                            @if($value->linkable)
                                <div class="col-md-6">
                                    <div class="file-field input-field">
                                        <div class="btn">
                                            <span>{{$value->title}}</span>
                                            <input name="{{"files[$value->id]"}}" type="file">
                                        </div>
                                        <div class="file-path-wrapper">
                                            <input class="file-path validate" type="text">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    @if(isset($value->settings->link))
                                        {!! view('share.forms.input',
                                        ['name' => "string[$value->id][link]",'class'=>'dleft','title' => 'لینک','value'=>$value->settings->link]) !!}
                                    @else
                                        {!! view('share.forms.input',
                                        ['name' => "string[$value->id][link]",'class'=>'dleft','title' => 'لینک']) !!}
                                    @endif
                                </div>
                            @else
                                <div class="col-md-12 mt20">
                                    <div class="file-field input-field">
                                        <div class="btn">
                                            <span>{{$value->title}}</span>
                                            <input name="{{"files[$value->id]"}}" type="file">
                                        </div>
                                        <div class="file-path-wrapper">
                                            <input class="file-path validate" type="text">
                                        </div>
                                    </div>
                                </div>
                            @endif

                            @if(isset($value->settings->value))
                                <div class="col-md-12">
                                    <img src="{{asset($value->settings->value)}}"
                                         class="img-responsive photo z-depth-2">
                                </div>
                            @endif
                        @endif

                    @endforeach
                </div>
            @endforeach

            @if($list->count())
                <div class="col-md-12 mb20 mt20 ">
                    <button class="waves-effect waves-light btn quarter center-block blue-grey darken-2">ذخیره</button>
                </div>
            @else
                <div class="col-md-12 mt20 mb30">
                    <h4 class="text-center">تنظیماتی موجود نیست</h4>
                </div>
            @endif

        </div>
    </form>
@endsection

@push('scripts')
    <script src="{{asset('assets/plugins/ck4/ckeditor.js')}}"></script>
    <script src="{{asset('assets/plugins/ck4/config.js')}}"></script>
    <script src="{{asset('assets/plugins/select2/select2.js')}}"></script>



    <script>
        $(document).ready(function() {
            $('.article').select2({
                dir:'rtl',
                closeOnSelect:false,
                multiple:true,
                minimumInputLength: 1,
                ajax: {
                    url: '/api/articles/front/v1/articles',
                    dataType: 'json',
                    data: function (params) {
                        return {
                            query: params.term,
                            page : params.page
                        };
                    },
                    processResults: function (data,params) {
                        params.page = params.page || 1;
                        return {
                            results: data.data,
                            pagination: {
                                more : (params.page  * 10) < data.total
                            }
                        };
                    },
                    delay: 250,
                    type:'GET',
                },
                templateResult: function (repo) {
                    return repo.id + ' - ' + repo.title;
                },
                templateSelection: function (repo) {
                    if (repo.title) {
                        return repo.id + ' - ' + repo.title;
                    } else {
                        return repo.id + ' - ' + repo.text;
                    }
                },
            });
            $('.product').select2({
                dir:'rtl',
                closeOnSelect:false,
                multiple:true,
                minimumInputLength: 1,
                ajax: {
                    url: '/api/products/front/v1/product',
                    dataType: 'json',
                    data: function (params) {
                        return {
                            query: params.term,
                            page : params.page
                        };
                    },
                    processResults: function (data,params) {
                        params.page = params.page || 1;
                        return {
                            results: data.data,
                            pagination: {
                                more : (params.page  * 10) < data.total
                            }
                        };
                    },
                    delay: 250,
                    type:'GET',
                },
                templateResult: function (repo) {
                    return repo.id + ' - ' + repo.title;
                },
                templateSelection: function (repo) {
                    if (repo.title) {
                        return repo.id + ' - ' + repo.title;
                    } else {
                        return repo.id + ' - ' + repo.text;
                    }
                },
            });


            CKEDITOR.replaceClass = 'editor';
            CKEDITOR.config.filebrowserImageBrowseUrl = '/panel/admin/cms-filemanager?type=Images';
            CKEDITOR.config.filebrowserImageUploadUrl = '/panel/admin/cms-filemanager/upload?type=Images&_token=';
            CKEDITOR.config.filebrowserBrowseUrl = '/panel/admin/cms-filemanager?type=Files';
            CKEDITOR.config.filebrowserUploadUrl = '/panel/admin/cms-filemanager/upload?type=Files&_token=';
        });

    </script>
@endpush

@push('styles')
    <link rel="stylesheet" href="{{asset('assets/plugins/select2/select2.css')}}">

    <style>
        .select2-container--default .select2-selection--multiple .select2-selection__choice {
            background-color: #41b883 !important;
            padding: 2px 8px 2px 16px !important;

        }
        .select2-container--default .select2-selection--multiple .select2-selection__choice__remove {
            color: #266d4d !important;
            cursor: pointer !important;
            display: inline-block !important;
            font-weight: bold !important;
            margin-right: 2px !important;
        }

        .tabs .tab a ,.tabs .tab a.active, .tabs .tab a:hover{
            color: #ffffff;
        }
        .tabs .indicator {
            background-color: #f5f5f5;
        }
        .photo {
            width: auto;
            height: 80px;
            border-radius: 4px;
        }
    </style>
@endpush
