@extends('admin.layout.master')

@section('content')
    <form method="post" action="{{route('admin.setting.admin.index')}}">
        {{ csrf_field() }}
        <div class="row white z-depth-1">
            <div class="col-md-12 mb10">
                <span class="blue-grey darken-2 white-text title z-depth-2">ایجاد تنظیمات</span>
                @include('share.extra.back2',['route'=>route('admin.setting.admin.index')])
            </div>

            <div class="col-md-6">
                @include('share.forms.select',['name'=>'category_id','title'=>'دسته بندی تنظیمات','options'=>$settingCat])
            </div>
            <div class="col-md-6">
                @include('share.forms.select',['name'=>'type','title'=>'نوع',
                'options'=>['string'=>'string','file'=>'file','boolean'=>'boolean','textarea'=>'textarea','editor'=>'editor']])
            </div>
            <div class="clearfix"></div>
            <div class="col-md-6">
                @include('share.forms.input',['name'=>'title','title'=>'تیتر'])
            </div>
            <div class="col-md-6">
                @include('share.forms.input',['name'=>'name','class'=>'dleft','title'=>'نام'])
            </div>
            <div class="clearfix"></div>
            <div class="col-md-12">
                @include('share.forms.input',['name'=>'value','title'=>'مقدار','class'=>'dleft'])
            </div>
            <div class="col-md-6">
                @include('share.forms.switch',['name'=>'linkable','title'=>'لینک','checked'=>0])
            </div>
            <div class="col-md-6">
                @include('share.forms.switch',['name'=>'status','title'=>'فعال','checked'=>1])
            </div>
            <div class="clearfix"></div>
            <div class="col-md-12 mb20 mt20 ">
                <button class="waves-effect waves-light btn quarter center-block blue darken-1">ایجاد</button>
            </div>

        </div>
    </form>
@endsection

@push('scripts')
    <script>
        $(document).ready(function() {
            $('select').material_select();
        });
    </script>
@endpush
