@extends('admin.layout.master')

@section('content')
    <div class="row">
        <div class="col-md-12 ">
            <ol class="breadcrumb">
                <li><a href="{{route('admin.home')}}">صفحه اصلی</a></li>
                <li><a href="{{route('admin.ticketdepartment.index')}}">لیست دپارتمان ها</a></li>
                <li class="active">ایجاد دپارتمان</li>
            </ol>
        </div>
    </div>

    <form method="post" action="{{route('admin.ticketdepartment.store')}}" enctype="multipart/form-data">
        {{ csrf_field() }}
        <div class="row white z-depth-1">
            <div class="col-md-12">
                <span class="blue-grey darken-2 white-text title z-depth-2">ایجاد تیکت دپارتمان</span>
                @include('share.extra.back2',['route'=>route('admin.ticketdepartment.index')])
            </div>

            <div class="col-md-6">
                @include('share.forms.input',['name'=>'title','title'=>'تیتر'])
            </div>
            <div class="col-md-6">
                @include('share.forms.input',['name'=>'order','class'=>'dleft','title'=>'موقعیت','value'=>1])
            </div>
            <div class="clearfix"></div>
            <div class="col-md-6">
                @include('share.forms.file',['name'=>'picture','title'=>'عکس'])
            </div>
            <div class="col-md-6 mt25">
                @include('share.forms.switch',['name'=>'status','title'=>'وضعیت','checked'=>true])
            </div>

            <div class="col-md-12 mb20 mt20">
                <button class="waves-effect waves-light btn quarter center-block blue-grey darken-2">ذخیره</button>
            </div>

        </div>
    </form>
@endsection
