@extends('admin.layout.master')

@section('content')
    <div class="row">
        <div class="col-md-12 ">
            <ol class="breadcrumb">
                <li><a href="{{route('admin.home')}}">صفحه اصلی</a></li>
                <li><a href="{{route('admin.ticketdepartment.index')}}">لیست دپارتمان ها</a></li>
                <li class="active">ویرایش آزمون</li>
            </ol>
        </div>
    </div>

    <form method="post" action="{{route('admin.ticketdepartment.update',$ticketdepartment->id)}}" enctype="multipart/form-data">
        {{ method_field('PUT') }}
        {{ csrf_field() }}
        <div class="row white z-depth-1">
            <div class="col-md-12">
                <span class="blue-grey darken-2 white-text title z-depth-2">ویرایش تیکت دپارتمان</span>
                @include('share.extra.back2',['route'=>route('admin.ticketdepartment.index')])
            </div>

            <div class="col-md-6">
                @include('share.forms.input',['name'=>'title','title'=>'تیتر','value'=>$ticketdepartment->title])
            </div>
            <div class="col-md-6">
                @include('share.forms.input',['name'=>'order','class'=>'dleft','title'=>'موقعیت','value'=>$ticketdepartment->order])
            </div>
            <div class="clearfix"></div>
            <div class="col-md-6">
                @include('share.forms.file',['name'=>'picture','title'=>'عکس'])
                <img height="200px" class="img-raised" src="{{asset($ticketdepartment->picture)}}" alt="">
            </div>
            <div class="col-md-6 mt25">
                @include('share.forms.switch',['name'=>'status','title'=>'وضعیت','checked'=>$ticketdepartment->status])
            </div>

            <div class="col-md-12 mb20 mt20 ">
                <button class="waves-effect waves-light btn quarter center-block blue-grey darken-2">دخیره</button>
            </div>

        </div>
    </form>
@endsection