@extends('admin.layout.master')

@section('content')
    <form method="post" action="{{route('admin.tickets.update',$ticket->id)}}" enctype="multipart/form-data">
        {{ method_field('PUT') }}
        {{ csrf_field() }}
        <div class="row white z-depth-1">
            <div class="col-md-12">
                <span class="blue-grey darken-2 white-text title z-depth-2">ویرایش پیام</span>
                @include('share.extra.back2',['route'=>route('admin.tickets.index')])
            </div>

            <div class="col-md-6">
                <label for="departments">انتخاب دپارتمان</label>
                <multiselect id="departments" v-model="department.selected" :options="department.list" @search-change="search($event,'department')" :custom-label="customLabel" :multiple="false" :close-on-select="true" track-by="id" :internal-search="false">
                        <span v-if="department.list.length > 0 && isMoreResult('department')"  @click="moreResult('department')" class="waves-effect waves-light btn quarter center-block teal darken-2 mt20" slot="afterList">
                            <span v-if="department.loading"><i class="fa fa-spinner fa-pulse fa-3x fa-fw"></i></span>
                            <span v-else>موارد بیشتر</span>
                        </span>
                </multiselect>
                @include('share.forms.error',['name'=>'department_id'])
            </div>
            <div class="col-md-6">
                <label for="users">انتخاب کاربر</label>
                <multiselect id="users" v-model="user.selected" :options="user.list" @search-change="search($event,'user')" :custom-label="userLabel" :multiple="false" :close-on-select="true" track-by="id" :internal-search="false">
                        <span v-if="user.list.length > 0 && isMoreResult('user')"  @click="moreResult('user')" class="waves-effect waves-light btn quarter center-block teal darken-2 mt20" slot="afterList">
                            <span v-if="user.loading"><i class="fa fa-spinner fa-pulse fa-3x fa-fw"></i></span>
                            <span v-else>موارد بیشتر</span>
                        </span>
                </multiselect>
                @include('share.forms.error',['name'=>'user_id'])
            </div>
            <div class="clearfix mb20"></div>
            <div class="col-md-12 mb20">
                <label for="admins">انتخاب مدیران</label>
                <multiselect id="admins" v-model="admin.selected" :options="admin.list" @search-change="search($event,'admin')" :custom-label="userLabel" :multiple="true" :close-on-select="false" track-by="id" :internal-search="false">
                        <span v-if="admin.list.length > 0 && isMoreResult('admin')"  @click="moreResult('admin')" class="waves-effect waves-light btn quarter center-block teal darken-2 mt20" slot="afterList">
                            <span v-if="admin.loading"><i class="fa fa-spinner fa-pulse fa-3x fa-fw"></i></span>
                            <span v-else>موارد بیشتر</span>
                        </span>
                </multiselect>
                @include('share.forms.error',['name'=>'admins_id'])
            </div>
            <div class="col-md-12">
                @include('share.forms.input',['name'=>'title','title'=>'تیتر','value'=>$ticket->title])
            </div>
            <div class="col-md-6">
                @include('share.forms.select',['name'=>'priority','title'=>'اولویت','options'=>['urgent'=>'فوری','high'=>'بالا','medium'=>'متوسط','low'=>'پایین'],'selected'=>$ticket->priority])
            </div>
            <div class="col-md-6">
                @include('share.forms.select',['name'=>'status','title'=>'وضعیت','options'=>['open'=>'باز','pending'=>'در حال بررسی','close'=>'بسته','deactive'=>'غیر فعال'],'selected'=>$ticket->status])
            </div>
            <div class="col-md-12">
                @include('share.forms.textarea-Material',['name'=>'body','title'=>'توضیحات','value'=>$ticket->body])
            </div>
            <div class="col-md-6">
                @include('share.forms.file',['name'=>'file','title'=>'آپلود فایل'])
            </div>
            @if($ticket->pathFile)
                <div class="col-md-6 mt20 text-center">
                    <a class="waves-effect waves-light btn" href="{{asset($ticket->pathFile)}}" download><i class="material-icons right">attach_file</i>دانلود فایل</a>
                </div>
            @endif

            <div class="col-md-12 mb20 mt20">
                <button class="waves-effect waves-light btn quarter center-block blue-grey darken-2">ذخیره</button>
            </div>
            <div>
                <input type="hidden" id="department_id" name="department_id" value="{{$ticket->ticketDepartment_id}}">
                <input type="hidden" id="user_id" name="user_id" value="{{$ticket->user_id}}">
                <input type="hidden" id="admins_id" name="admins_id" value="{{$ticket->referer->pluck('id')}}">
            </div>

        </div>
    </form>
@endsection

@push('scripts')
    <script src="{{asset('assets/plugins/vueselect/vueselect.js')}}"></script>

    <script>
        $(document).ready(function () {
            $('select').material_select();
        });

        Vue.component('Multiselect', VueMultiselect.default);
        new Vue({
            el:'#app',
            data:{
                ax:axios.create({baseURL: baseUrl,headers:{'Authorization':'Bearer {{auth()->user()->api_token}}'}}),

                departments:[],
                departmentSelected:{!! $ticket->department !!},

                users:[{!! $ticket->user !!}],
                userSelected:{!! $ticket->user !!},

                admins:{!! $ticket->referer !!},
                adminSelected:{!! $ticket->referer !!},

                department:{
                    url:'/v1/admin/tickets/department',
                    list:[{!! $ticket->department !!}],
                    selected:{!! $ticket->department !!},
                    query:'',
                    params:{},
                    data:[],
                    loading:false
                },
                user:{
                    url:'/v1/admin/users/user',
                    list:[{!! $ticket->user !!}],
                    selected:{!! $ticket->user !!},
                    query:'',
                    params:{},
                    data:[],
                    loading:false
                },
                admin:{
                    url:'/v1/admin/users/user',
                    list:{!! $ticket->referer !!},
                    selected:{!! $ticket->referer !!},
                    query:'',
                    params:{},
                    data:[],
                    loading:false
                },

            },
            methods:{
                userLabel: function (element) {
                    return element.id + ' - ' + element.firstName + ' - ' + element.lastName;
                },

                search: function (query, field, extraQuery = {}) {
                    this[field].params = extraQuery;
                    if (query) {
                        this[field].params.query = query;
                    }

                    if (query !== '' || query === null) {
                        this.ax.get(this[field].url, {params: this[field].params}).then(function (response) {
                            this[field].query = query;
                            this[field].list = response.data.data;
                            this[field].data = response.data;
                        }.bind(this));
                    }
                },
                customLabel: function (element) {
                    return element.id + ' - ' + element.title;
                },
                isMoreResult: function (field) {
                    return (this[field].data.current_page + 1 <= this[field].data.last_page);
                },
                moreResult: function (field) {
                    if (this.isMoreResult(field)) {
                        this[field].loading = true;
                        this[field].params.page = this[field].data.current_page + 1;

                        this.ax.get(this[field].url, {params: this[field].params}).then(function (response) {
                            this[field].list = this[field].list.concat(response.data.data);
                            this[field].data = response.data;
                            this[field].loading = false;
                        }.bind(this));
                    }
                }
            },
            watch:{
                'department.selected': function () {
                    if (this.department.selected) {
                        document.getElementById('department_id').value = this.department.selected.id;
                    } else {
                        document.getElementById('department_id').value = null;
                    }
                },
                'admin.selected': function () {
                    var output = [];
                    for (var i = 0; i < this.admin.selected.length; i++) {
                        output.push(this.admin.selected[i]['id']);
                    }
                    document.getElementById('admins_id').value = JSON.stringify(output);
                },
                'user.selected': function () {
                    if (this.user.selected) {
                        document.getElementById('user_id').value = this.user.selected.id;
                    } else {
                        document.getElementById('user_id').value = null;
                    }
                }
            }
        });
    </script>

@endpush

@push('styles')
    <link rel="stylesheet" href="{{asset('assets/plugins/vueselect/vueselect.css')}}">
@endpush
