@extends('admin.layout.master')

@section('content')
    <div class="row">
        <div class="col-md-12 ">
            <ol class="breadcrumb">
                <li><a href="{{route('admin.home')}}">صفحه اصلی</a></li>
                <li><a href="{{route('admin.tickets.index')}}">لیست پیام ها</a></li>
                <li class="active">نمایش پیام</li>
            </ol>
        </div>
    </div>

    <div class="row white z-depth-1">
        <div class="clearfix"></div>
        <div class="col-md-12">
            <h2 class="text-center">{{$ticket->title}}</h2>
            <p>{{$ticket->body}}</p>
            @if($ticket->pathFile)
                <a class="waves-effect waves-light btn mt10" href="{{asset($ticket->pathFile)}}" download><i class="material-icons right">attach_file</i>دانلود فایل</a>
            @endif
            <hr>
        </div>
        <div class="col-md-6">
            <p class=" text-center pd5 blue-grey darken-2 white-text br4 z-depth-1 mb10 mr10 quarter">{{$ticket->user->firstName.' '.$ticket->user->lastName}}</p>
        </div>
        <div class="col-md-6 text-left">
            <p class="text-center pd5 blue-grey darken-2 white-text br4 z-depth-1 mb10 mr10 half dleft right">{{toPersian($ticket->created_at)}}</p>
        </div>
    </div>

    @foreach($messages as $message)
        <div class="row white z-depth-1 mt20">
            <div class="col-md-12 mt5">
                @if($message->user_id == auth()->user()->id)
                    @can('ticketMessage_update')
                        <a href="{{route('admin.ticketmessages.indexMessage',[$message->ticket_id,'message_id'=>$message->id])}}" class="btn-floating waves-effect waves-light blue"><i class="material-icons">edit</i></a>
                    @endcan
                    @can('ticketMessage_destroy')
                            <form style="display: inline" method="post" action="{{route('admin.ticketmessages.destroy',$message->id)}}">
                                {{ csrf_field() }}
                                {{ method_field('DELETE') }}
                                <button type="submit" href="{{route('admin.ticketmessages.destroy',$message->id)}}" class="btn-floating waves-effect waves-light red"><i class="material-icons">delete</i></button>
                            </form>
                    @endcan
                @endif
            </div>
            <div class="col-md-12">
                <h2 class="text-center">{{$message->title}}</h2>
                <p>{{$message->body}}</p>
                @foreach($message->files as $file)
                    <a class="waves-effect waves-light btn mt10" href="{{asset($file->path)}}" download><i class="material-icons right">attach_file</i>دانلود فایل</a>
                @endforeach
                <hr>
            </div>
            <div class="col-md-4">
                <p class="text-center pd5 blue-grey darken-1 white-text br4 z-depth-1 mb10 col-md-6">{{$message->user->firstName.' '.$message->user->lastName}}</p>
            </div>
            <div class="col-md-4">
                <p class="text-center pd5 blue-grey darken-1 white-text br4 z-depth-1 mb10 col-md-6 col-md-offset-3">وضعیت نمایش : {{($message->type == 'all')?'همه':'مدیران'}}</p>
            </div>
            <div class="col-md-4 text-left">
                <p class="text-center pd5 blue-grey darken-2 white-text br4 z-depth-1 mb10 mr10 half dleft right">{{toPersian($message->created_at)}}</p>
            </div>
        </div>
    @endforeach

    <div class="row white z-depth-1 mt40">
        @if(request()->has('message_id'))
            <form method="post" action="{{route('admin.ticketmessages.update',$ticketMessage->id)}}" enctype="multipart/form-data">
                {{ method_field('PUT') }}
                {{ csrf_field() }}
                <div class="col-md-12">
                    <span class="blue-grey darken-2 white-text title z-depth-2">ویرایش پاسخ</span>
                </div>
                <div class="col-md-12">
                    @include('share.forms.textarea-Material',['name'=>'body','title'=>'Text','value'=>$ticketMessage->body])
                </div>
                <div class="col-md-6">
                    @include('share.forms.select',['name'=>'type','title'=>'وضعیت نمایش','options'=>['all'=>'همه','note'=>'مدیران'],'selected'=>$ticketMessage->type])
                </div>
                <div class="col-md-6">
                    @include('share.forms.file',['name'=>'files[]','title'=>'آپلود فایل','multiple'=>true])
                </div>


                <div class="col-md-12 mb20 mt20">
                    <button class="waves-effect waves-light btn quarter center-block blue-grey darken-2">ذخیره</button>
                </div>
                <div>
                    <input type="hidden" name="ticket_id" value="{{$ticket->id}}">
                </div>

            </form>
        @else
            <form method="post" action="{{route('admin.ticketmessages.store')}}" enctype="multipart/form-data">
                {{ csrf_field() }}
                <div class="col-md-12">
                    <span class="blue-grey darken-2 white-text title z-depth-2">ایجاد پاسخ</span>
                </div>
                <div class="col-md-12">
                    @include('share.forms.textarea-Material',['name'=>'body','title'=>'Text'])
                </div>
                <div class="col-md-6">
                    @include('share.forms.select',['name'=>'type','title'=>'وضعیت نمایش','options'=>['all'=>'همه','note'=>'مدیران'],'selected'=>'all'])
                </div>
                <div class="col-md-6">
                    @include('share.forms.file',['name'=>'files[]','title'=>'آپلود فایل','multiple'=>true])
                </div>


                <div class="col-md-12 mb20 mt20">
                    <button class="waves-effect waves-light btn quarter center-block blue-grey darken-2">ذخیره</button>
                </div>
                <div>
                    <input type="hidden" name="ticket_id" value="{{$ticket->id}}">
                </div>

            </form>
        @endif
    </div>

    @include('share.extra.back',['route'=>route('admin.ticketmessages.index')])
@endsection

@push('scripts')

    <script>
        $(document).ready(function () {
            $('select').material_select();
        });
    </script>

@endpush
