@extends('admin.layout.master')

@section('content')
    <div class="row">
        <div class="col-md-12 ">
            <ol class="breadcrumb">
                <li><a href="{{route('admin.home')}}">صفحه اصلی</a></li>
                <li><a href="{{route('admin.wallet.transaction.index')}}">لیست تراکنش کیف پول</a></li>
                <li class="active">ایجاد تراکنش کیف پول</li>
            </ol>
        </div>
    </div>

    <form method="post" action="{{route('admin.wallet.transaction.store')}}">
        {{ csrf_field() }}
        <div class="row white z-depth-1">
            <div class="col-md-12">
                <span class="blue-grey darken-2 white-text title z-depth-2">ایجاد تراکنش کیف پول</span>
                @include('share.extra.back2',['route'=>route('admin.wallet.transaction.index')])
            </div>


            <div class="col-md-6">
                <label for="wallets">انتخاب کیف پول</label>
                <multiselect id="wallets" v-model="wallet.selected" :options="wallet.list" @search-change="search($event,'wallet')" :custom-label="walletLabel" :multiple="false" :close-on-select="true" track-by="id" :internal-search="false">
                        <span v-if="wallet.list.length > 0 && isMoreResult('wallet')"  @click="moreResult('wallet')" class="waves-effect waves-light btn quarter center-block teal darken-2 mt20" slot="afterList">
                            <span v-if="wallet.loading"><i class="fa fa-spinner fa-pulse fa-3x fa-fw"></i></span>
                            <span v-else>موارد بیشتر</span>
                        </span>
                </multiselect>
                @include('share.forms.error',['name'=>'wallet_id'])
            </div>


            <div class="col-md-6 mt20">
                @include('share.forms.input',['name'=>'amount','class'=>'dleft price','title'=>'موجودی (تومان)'])
            </div>

            <div class="clearfix"></div>
            <div class="col-md-6">
                @include('share.forms.switch',['name'=>'status','title'=>'فعال','checked'=>true])
            </div>

            <div>
                <input type="hidden" id="wallet_id" name="wallet_id">
            </div>

            <div class="col-md-12 mb20 mt20 ">
                <button class="waves-effect waves-light btn quarter center-block blue darken-1">ذخیره</button>
            </div>

        </div>

    </form>
@endsection


@push('scripts')
    <script src="{{asset('assets/plugins/number/jquery.number.min.js')}}"></script>
    <script src="{{asset('assets/plugins/vueselect/vueselect.js')}}"></script>

    <script>
        $(document).ready(function () {
            $('.price').number(true);
        });

        Vue.component('Multiselect', VueMultiselect.default);
        new Vue({
            el:'#app',
            data:{
                ax:axios.create({baseURL: baseUrl,headers:{'Authorization':'Bearer {{auth()->user()->api_token}}'}}),

                wallet:{
                    url:'/admin/v1/wallet/wallet ',
                    list:[],
                    selected:[],
                    query:'',
                    params:{},
                    data:[],
                    loading:false
                },
            },
            created: function () {
                this.search(null, 'wallet');
            },
            methods:{
                search: function (query, field, extraQuery = {}) {
                    this[field].params = extraQuery;
                    if (query) {
                        this[field].params.query = query;
                    }

                    if (query !== '' || query === null) {
                        this.ax.get(this[field].url, {params: this[field].params}).then(function (response) {
                            this[field].query = query;
                            this[field].list = response.data.data;
                            this[field].data = response.data;
                        }.bind(this));
                    }
                },

                walletLabel: function (element) {
                    if (element.id) {
                        return element.id + ' - ' + element.model.firstName + ' - ' + element.model.lastName;
                    } else {
                        return element.id + ' - ' + element.title;
                    }
                },
                customLabel: function (element) {
                    return element.id + ' - ' + element.title;
                },
                isMoreResult: function (field) {
                    return (this[field].data.current_page + 1 <= this[field].data.last_page);
                },
                moreResult: function (field) {
                    if (this.isMoreResult(field)) {
                        this[field].loading = true;
                        this[field].params.page = this[field].data.current_page + 1;

                        this.ax.get(this[field].url, {params: this[field].params}).then(function (response) {
                            this[field].list = this[field].list.concat(response.data.data);
                            this[field].data = response.data;
                            this[field].loading = false;
                        }.bind(this));
                    }
                }
            },
            watch:{
                'wallet.selected': function () {
                    if (this.wallet.selected) {
                        document.getElementById('wallet_id').value = this.wallet.selected.id;
                    } else {
                        document.getElementById('wallet_id').value = null;
                    }
                },
            }
        });
    </script>

@endpush

@push('styles')
    <link rel="stylesheet" href="{{asset('assets/plugins/vueselect/vueselect.css')}}">
@endpush
