@extends('admin.layout.master')

@section('content')
    <form method="post" action="{{route('acl.giveRolesUpdate',$user->id)}}">
        {{ csrf_field() }}
        {{ method_field('PATCH') }}
        <div class="row white z-depth-1">
            <div class="col-md-12">
                <span class="blue-grey darken-2 white-text title z-depth-2">ویرایش نقش کاربر</span>
            </div>
            <div class="col-md-6 mb20">
                <label class="pd5 br4 blue-grey white-text center-block text-center z-depth-1">ایمیل</label>
                <p class="text-center">{{$user->email}}</p>
            </div>
            <div class="col-md-6 mb20">
                <label class="pd5 br4 blue-grey white-text center-block text-center z-depth-1">نام کاربری</label>
                <p class="text-center">{{$user->username}}</p>
            </div>
            <div class="clearfix-lg clearfix-md"></div>
            <div class="col-md-6 mb20">
                <label class="pd5 br4 blue-grey white-text center-block text-center z-depth-1">نام</label>
                <p class="text-center">{{$user->firstName}}</p>
            </div>
            <div class="col-md-6 mb20">
                <label class="pd5 br4 blue-grey white-text center-block text-center z-depth-1">نام خانوادگی</label>
                <p class="text-center">{{$user->lastName}}</p>
            </div>

            <div class="col-md-12 mb20">
                <multiselect v-model="rolesSelected" :options="roles"
                             label="name" track-by="id" :searchable="true" :multiple="true" :close-on-select="false" :clear-on-select="false"
                             placeholder="انتخاب مجوز">
                    <span slot="noResult">نتیجه یافت نشد</span></multiselect>
            </div>
            <div>
                <input id="roles" type="hidden" name="roles" >
            </div>
            <div class="col-md-12 mb20 mt20 ">
                <button class="waves-effect waves-light btn quarter center-block blue-grey darken-2">ذخیره</button>
            </div>
        </div>

    </form>
    @include('share.extra.back',['route'=>route('acl.list')])
@endsection

@push('scripts')
<script src="{{asset('assets/js/vueselect.js')}}"></script>
<script>
    Vue.component('Multiselect', VueMultiselect.default);
    new Vue({
        el:'#app',
        data:{
            ax:axios.create({baseURL: '/admin/'}),
            roles:[],
            rolesSelected:[]
        },
        created:function () {
            this.ax.post('acl/users/{{$user->id}}/roles').then(function (response) {
                    this.rolesSelected = response.data;
                }.bind(this));
            this.ax.post('roles/list').then(function (response) {
                this.roles = response.data;
            }.bind(this));
        },
        watch:{
            rolesSelected:function () {
                var output = [];
                for (var i=0; i < this.rolesSelected.length ; i++)
                    output.push(this.rolesSelected[i]['id']);
                document.getElementById('roles').value = JSON.stringify(output);
            }
        }
    });
</script>
@endpush
