@extends('admin.layout.master')

@section('content')
    <div class="row">
        <a v-show="isDestroy" @click="modal.destroy = true" class="btn-floating btn-large waves-effect waves-light red fixed"><i class="material-icons">delete</i></a>
        <a style="right: 88px" v-show="isDestroy" @click="changeMode('')" class="btn-floating btn-large waves-effect waves-light blue-grey fixed"><i class="material-icons">close</i></a>
        <div v-show="!isDestroy" class="fixed-action-btn click-to-toggle">
            <a class="btn-floating btn-large teal">
                <i class="material-icons">menu</i>
            </a>
            <ul>
                <li><a @click.prevent.default="changeMode('edit')"  class="btn-floating blue"><span>ویرایش</span><i class="material-icons">mode_edit</i></a></li>
            </ul>
        </div>
    </div>
    <div class="row white z-depth-1">
        <div class="col-md-12">
            <div class="input-field">
                <input id="query" name="query" type="text" class="validate" v-model="query">
                <label for="query">جست و جو</label>
            </div>
        </div>
        <div class="col-md-12 pd4">
            <div class="table-responsive">
                <table class="table table-bordered table-hover white">
                    <thead class="blue-grey darken-2 white-text">
                    <tr>
                        <th @click="sort('id')">شناسه
                            <i v-if="params.id === 'asc'" class="fa fa-sort-amount-asc" aria-hidden="true"></i>
                            <i v-if="params.id === 'desc'" class="fa fa-sort-amount-desc" aria-hidden="true"></i>
                        </th>
                        <th @click="sort('email')">ایمیل
                            <i v-if="params.email === 'asc'" class="fa fa-sort-amount-asc" aria-hidden="true"></i>
                            <i v-if="params.email === 'desc'" class="fa fa-sort-amount-desc" aria-hidden="true"></i>
                        </th>
                        <th @click="sort('userName')">نام کاربری
                            <i v-if="params.userName === 'asc'" class="fa fa-sort-amount-asc" aria-hidden="true"></i>
                            <i v-if="params.userName === 'desc'" class="fa fa-sort-amount-desc" aria-hidden="true"></i>
                        </th>
                        <th @click="sort('firstName')">نام
                            <i v-if="params.firstName === 'asc'" class="fa fa-sort-amount-asc" aria-hidden="true"></i>
                            <i v-if="params.firstName === 'desc'" class="fa fa-sort-amount-desc" aria-hidden="true"></i>
                        </th>
                        <th @click="sort('lastName')">نام خانوادگی
                            <i v-if="params.lastName === 'asc'" class="fa fa-sort-amount-asc" aria-hidden="true"></i>
                            <i v-if="params.lastName === 'desc'" class="fa fa-sort-amount-desc" aria-hidden="true"></i>
                        </th>
                        <th @click="sort('nationalCode')">تعداد نقش
                            <i v-if="params.nationalCode === 'asc'" class="fa fa-sort-amount-asc" aria-hidden="true"></i>
                            <i v-if="params.nationalCode === 'desc'" class="fa fa-sort-amount-desc" aria-hidden="true"></i>
                        </th>
                    </tr>
                    </thead>
                    <tbody>
                    <tr v-for="item in itemList" @click="handleMode(item)">
                        <td v-if="!isDestroy" v-text="item.id"></td>
                        <td v-else>
                            <input v-model="model.destroy" type="checkbox" :id="item.id" :value="item.id"/>
                            <label :for="item.id" v-text="item.id"></label>
                        </td>
                        <td v-text="item.email"></td>
                        <td v-text="item.userName"></td>
                        <td v-text="item.firstName"></td>
                        <td v-text="item.lastName"></td>
                        <td v-text="item.role_count"></td>
                    </tr>
                    </tbody>
                </table>
            </div>
        </div>
        <div class="col-md-12">
            <paginate v-if="itemList" v-model="itemList" :is-reset="reset" :url="currentUrl" :params="params"></paginate>
        </div>
    </div>
    <vue-toastr ref="toastr"></vue-toastr>
@endsection

@push('scripts')
<script src="{{asset('assets/js/paginator.js')}}"></script>
<script>
    new Vue({
        el:'#app',
        data:{
            currentUrl:location.pathname,
            instance:axios.create({baseURL: location.pathname,}),
            itemList:[],
            reset:false,
            params:{},
            query:'',
            modal:{
                destroy:false
            },
            model:{
                mode:'create',
                id:'',
                title:'',
                body:'',
                destroy:[]
            }
        },
        methods:{
            sort: function (query) {
                this.reset = !this.reset;
                if (this.changeSort(this.params[query]) === '') {
                    delete this.params[query];
                } else {
                    this.params[query] = this.changeSort(this.params[query]);
                }
            },
            changeSort: function (value) {
                if (value === '' || value === undefined) {
                    return 'desc';
                } else if (value === 'desc') {
                    return 'asc'
                } else {
                    return ''
                }
            },

            changeMode:function (mode) {
                $('.fixed-action-btn').closeFAB();
                   this.model.mode = mode;
            },
            handleMode:function (item) {
                if (this.isEdit) {
                    this.modelEdit(item);
                }
            },

            modelEdit:function (item) {
                window.location.href = window.location.href+'/'+item.id+"/giverole";
            },
            modelDestroy:function () {
                this.instance.post('destroy',{
                    destroy: this.model.destroy,
                }).then(function (response) {
                    this.reset = !this.reset;
                    this.model.destroy = [];
                    this.modal.destroy = false;
                    this.$refs.toastr.defaultPosition = "toast-bottom-left";
                    this.$refs.toastr.s("حذف شد");
                }.bind(this));
            }
        },
        computed:{
            isEdit:function () {
                return (this.model.mode === 'edit');
            },
            isDestroy:function () {
                return (this.model.mode === 'destroy');
            },
        },
        watch:{
            query:function () {
                this.params.query = this.query;
                this.reset = !this.reset;
            }
        },
        components: {
            'vue-toastr': window.vueToastr,
        }
    });
</script>
@endpush
@push('styles')
<style>
    .fixed-action-btn {
        right: 25px;
    }
    .fixed-action-btn ul a{
        width: 140px;
        -webkit-border-radius: 4px;
        -moz-border-radius: 4px;
        border-radius: 4px;
        text-align: right;
    }
    .fixed-action-btn ul a i {
        display: inline;
        position: absolute;
        top: 0;
        left: 55px;
    }
    .fixed-action-btn ul a span {
        position: absolute;
        right: 28px;
        bottom: 2px;
    }
    .fixed {
        position: fixed;
        right: 25px;
        bottom: 23px;
        z-index: 998;
    }
</style>
@endpush