@extends('admin.layout.master')

@section('content')
    <div class="row">
        <div class="col-md-12 ">
            <ol class="breadcrumb">
                <li><a href="{{route('admin.home')}}">صفحه اصلی</a></li>
                <li><a href="{{route('admin.users.index')}}">لیست کاربران</a></li>
                <li class="active">تغییر وضعیت</li>
            </ol>
        </div>
    </div>

    <div class="row white z-depth-1">
        <div class="col-md-12 por">
            <span class="blue-grey darken-2 white-text title z-depth-2">تغییر وضعیت کاربر</span>
            <a href="{{route('admin.users.index')}}" class="waves-effect waves-light btn blue darken-1 back-button"><i class="material-icons right">arrow_forward</i>بازگشت</a>
        </div>

        <div class="col-md-3">
            <h4 class="blue darken-3 white-text br4 pd4 z-depth-1 text-center">شناسه</h4>
            <p class="mt10 grey lighten-5 br4 pd4 z-depth-1 text-center">{{$user->id}}</p>
        </div>
        <div class="col-md-3">
            <h4 class="blue darken-3 white-text br4 pd4 z-depth-1 text-center">نام کاربری</h4>
            <p class="mt10 grey lighten-5 br4 pd4 z-depth-1 text-center">{{$user->userName}}</p>
        </div>
        <div class="col-md-3">
            <h4 class="blue darken-3 white-text br4 pd4 z-depth-1 text-center">نام</h4>
            <p class="mt10 grey lighten-5 br4 pd4 z-depth-1 text-center">{{$user->firstName}}</p>
        </div>
        <div class="col-md-3">
            <h4 class="blue darken-3 white-text br4 pd4 z-depth-1 text-center">نام خانوادگی</h4>
            <p class="mt10 grey lighten-5 br4 pd4 z-depth-1 text-center">{{$user->lastName}}</p>
        </div>
        <div class="clearfix mb20"></div>


        <div class="col-md-3">
            <h4 class="blue darken-3 white-text br4 pd4 z-depth-1 text-center">ایمیل</h4>
            <p class="mt10 grey lighten-5 br4 pd4 z-depth-1 text-center">{{$user->email}}</p>
        </div>
        <div class="col-md-3">
            <h4 class="blue darken-3 white-text br4 pd4 z-depth-1 text-center">نام پدر</h4>
            <p class="mt10 grey lighten-5 br4 pd4 z-depth-1 text-center">{{$user->fatherName}}</p>
        </div>
        <div class="col-md-3">
            <h4 class="blue darken-3 white-text br4 pd4 z-depth-1 text-center">جنسیت</h4>
            <p class="mt10 grey lighten-5 br4 pd4 z-depth-1 text-center">{{$user->genderApi}}</p>
        </div>
        <div class="col-md-3">
            <h4 class="blue darken-3 white-text br4 pd4 z-depth-1 text-center">شهر</h4>
            <p class="mt10 grey lighten-5 br4 pd4 z-depth-1 text-center">{{(isset($user->city->title))?$user->city->title:'ثبت نشده'}}</p>
        </div>
        <div class="clearfix mb20"></div>


        <div class="col-md-3">
            <h4 class="blue darken-3 white-text br4 pd4 z-depth-1 text-center">کد ملی</h4>
            <p class="mt10 grey lighten-5 br4 pd4 z-depth-1 text-center">{{$user->nationalCode}}</p>
        </div>
        <div class="col-md-3">
            <h4 class="blue darken-3 white-text br4 pd4 z-depth-1 text-center">شماره شناسنامه</h4>
            <p class="mt10 grey lighten-5 br4 pd4 z-depth-1 text-center">{{$user->certificateCode}}</p>
        </div>
        <div class="col-md-3">
            <h4 class="blue darken-3 white-text br4 pd4 z-depth-1 text-center">تاریخ تولد</h4>
            <p class="mt10 grey lighten-5 br4 pd4 z-depth-1 text-center">{{toPersian($user->birthday)}}</p>
        </div>
        <div class="col-md-3">
            <h4 class="blue darken-3 white-text br4 pd4 z-depth-1 text-center">محل تولد</h4>
            <p class="mt10 grey lighten-5 br4 pd4 z-depth-1 text-center">{{$user->birthplace}}</p>
        </div>
        <div class="clearfix mb20"></div>


        <div class="col-md-3">
            <h4 class="blue darken-3 white-text br4 pd4 z-depth-1 text-center">موبایل</h4>
            <p class="mt10 grey lighten-5 br4 pd4 z-depth-1 text-center">{{$user->mobile}}</p>
        </div>
        <div class="col-md-3">
            <h4 class="blue darken-3 white-text br4 pd4 z-depth-1 text-center">تلفن</h4>
            <p class="mt10 grey lighten-5 br4 pd4 z-depth-1 text-center">{{$user->telephone}}</p>
        </div>
        <div class="col-md-3">
            <h4 class="blue darken-3 white-text br4 pd4 z-depth-1 text-center">کد پستی</h4>
            <p class="mt10 grey lighten-5 br4 pd4 z-depth-1 text-center">{{$user->postalCode}}</p>
        </div>
        <div class="col-md-3">
            <h4 class="blue darken-3 white-text br4 pd4 z-depth-1 text-center">نوع کاربر</h4>
            <p class="mt10 grey lighten-5 br4 pd4 z-depth-1 text-center">{{($user->isAdmin == 'admin')?'مدیر':'کاربر'}}</p>
        </div>
        <div class="clearfix mb20"></div>


        <div class="col-md-12">
            <h4 class="blue darken-3 white-text br4 pd4 z-depth-1 text-center">آدرس</h4>
            <p class="mt10 grey lighten-5 br4 pd4 z-depth-1 text-center">{{$user->address}}</p>
        </div>
        <div class="clearfix mb20"></div>


        <div class="col-md-3">
            <h4 class="blue darken-3 white-text br4 pd4 z-depth-1 text-center">مهارت</h4>
            <p class="mt10 grey lighten-5 br4 pd4 z-depth-1 text-center">{{(isset($user->skill[0]))?$user->skill[0]->title:'ثبت نشده'}}</p>
        </div>
        <div class="col-md-3">
            <h4 class="blue darken-3 white-text br4 pd4 z-depth-1 text-center">ثبت مهارت در سامانه</h4>
            <p class="mt10 grey lighten-5 br4 pd4 z-depth-1 text-center">{{($user->saveSkill)?'بله':'خیر'}}</p>
        </div>
        <div class="col-md-3">
            <h4 class="blue darken-3 white-text br4 pd4 z-depth-1 text-center">آخرین مدرک تحصیلی</h4>
            <p class="mt10 grey lighten-5 br4 pd4 z-depth-1 text-center">{{$user->educationApi}}</p>
        </div>
        <div class="col-md-3">
            <h4 class="blue darken-3 white-text br4 pd4 z-depth-1 text-center">آخرین رشته و گرایش</h4>
            <p class="mt10 grey lighten-5 br4 pd4 z-depth-1 text-center">{{$user->fieldOfStudy}}</p>
        </div>
        <div class="clearfix mb20"></div>


        <div class="col-md-4">
            <h4 class="blue darken-3 white-text br4 pd4 z-depth-1 text-center">عکس آخرین مدرک تحصیلی</h4>
            @if($user->educationPicture)
                <a download="{{$user->educationPicture}}" href="{{asset($user->educationPicture)}}">
                    <img class="img-raised center-block" height="100px" src="{{asset($user->educationPicture)}}" alt="">
                </a>
            @endif
        </div>

        <div class="col-md-4">
            <h4 class="blue darken-3 white-text br4 pd4 z-depth-1 text-center">عکس پرسنلی</h4>
            @if($user->personalPicture)
                <a download="{{$user->personalPicture}}" href="{{asset($user->personalPicture)}}">
                    <img class="img-raised center-block" height="100px" src="{{asset($user->personalPicture)}}" alt="">
                </a>
            @endif
        </div>
        <div class="col-md-4">
            <h4 class="blue darken-3 white-text br4 pd4 z-depth-1 text-center">آخرین مدرک تحصیلی</h4>
            @if($user->nationalCardPicture)
                <a download="{{$user->nationalCardPicture}}" href="{{asset($user->nationalCardPicture)}}">
                    <img class="img-raised center-block" height="100px" src="{{asset($user->nationalCardPicture)}}" alt="">
                </a>
            @endif
        </div>
        <div class="clearfix mb20"></div>



        <form method="post" action="{{route('admin.users.changeStatusStore',$user->id)}}">
            {{ csrf_field() }}
            <div class="col-md-12 mb20">
                <label for="cardstatuses">انتخاب وضعیت ها</label>
                <multiselect id="cardstatuses" v-model="cardstatus.selected" :options="cardstatus.list" @search-change="search($event,'cardstatus')" :custom-label="customLabel" :multiple="true" :close-on-select="false" track-by="id" :internal-search="false">
                        <span v-if="cardstatus.list.length > 0 && isMoreResult('cardstatus')"  @click="moreResult('cardstatus')" class="waves-effect waves-light btn quarter center-block teal darken-2 mt20" slot="afterList">
                            <span v-if="cardstatus.loading"><i class="fa fa-spinner fa-pulse fa-3x fa-fw"></i></span>
                            <span v-else>موارد بیشتر</span>
                        </span>
                </multiselect>
                @include('share.forms.error',['name'=>'department_id'])
            </div>

            <div class="col-md-3 mt40">
                @include('share.forms.switch',['name'=>'canEdit','title'=>'قابل ویرایش','checked'=>$user->canEdit])
            </div>
            <div class="col-md-6 mt40">
                @include('share.forms.switch',['name'=>'isActive','title'=>'فعال','checked'=>$user->isActive])
            </div>

            <div>
                <input type="hidden" id="cardstatus_id" name="cardstatus_id" value="{{$serviceCardStatus->pluck('id')}}">
            </div>


            <div class="col-md-12 mb20 mt20 ">
                <button class="waves-effect waves-light btn quarter center-block blue darken-1">ذخیره</button>
            </div>
        </form>


    </div>
@endsection


@push('scripts')
    <script src="{{asset('assets/plugins/vueselect/vueselect.js')}}"></script>

    <script>
        $(document).ready(function () {
            $('select').material_select();
        });

        Vue.component('Multiselect', VueMultiselect.default);
        new Vue({
            el:'#app',
            data:{
                ax:axios.create({baseURL: baseUrl,headers:{'Authorization':'Bearer {{auth()->user()->api_token}}'}}),

                cardstatus:{
                    url:'/admin/v1/service/cardstatus',
                    list:{!! $serviceCardStatus !!},
                    selected:{!! $serviceCardStatus !!},
                    query:'',
                    params:{},
                    data:[],
                    loading:false
                },
            },
            created: function () {
                this.search(null, 'cardstatus');
            },
            methods:{
                search: function (query, field, extraQuery = {}) {
                    this[field].params = extraQuery;
                    if (query) {
                        this[field].params.query = query;
                    }

                    if (query !== '' || query === null) {
                        this.ax.get(this[field].url, {params: this[field].params}).then(function (response) {
                            this[field].query = query;
                            this[field].list = response.data.data;
                            this[field].data = response.data;
                        }.bind(this));
                    }
                },
                customLabel: function (element) {
                    return element.id + ' - ' + element.title;
                },
                isMoreResult: function (field) {
                    return (this[field].data.current_page + 1 <= this[field].data.last_page);
                },
                moreResult: function (field) {
                    if (this.isMoreResult(field)) {
                        this[field].loading = true;
                        this[field].params.page = this[field].data.current_page + 1;

                        this.ax.get(this[field].url, {params: this[field].params}).then(function (response) {
                            this[field].list = this[field].list.concat(response.data.data);
                            this[field].data = response.data;
                            this[field].loading = false;
                        }.bind(this));
                    }
                }
            },
            watch:{
                'cardstatus.selected': function () {
                    var output = [];
                    for (var i = 0; i < this.cardstatus.selected.length; i++) {
                        output.push(this.cardstatus.selected[i]['id']);
                    }
                    document.getElementById('cardstatus_id').value = JSON.stringify(output);
                },
            }
        });
    </script>

@endpush

@push('styles')
    <link rel="stylesheet" href="{{asset('assets/plugins/vueselect/vueselect.css')}}">
@endpush
