@extends('front.layouts.master')

@section('content')
    <div class="container register" id="app">
        <div class="rw"></div>
        <div class="row">
            <br><br><br><br>


            <div class="clearfix"></div>
            <div class="col-md-6 col-md-offset-3 auth-login">
                <form class="form-horizontal" role="form" method="POST" action="{{ route('auth.confirm.store')}}">
                    {{ csrf_field() }}
                    <div class="card">
                        <div class="card-content row">

                            <div class="col-md-12 mt25 register-steps">
                                <div class="col-md-12 pd0 text-center active text-center">
                                    <h1 class="text-center">تاییده موبایل</h1>
                                </div>
                            </div>
                            <div class="col-md-12 mt20"></div>

                            <div class="col-md-12">
                                @include('share.forms.input',['name'=>'code','id'=>'code','title'=>'کد ارسالی را وارد نمایید','class'=>'dleft','extraFields'=>'autocomplete="off"'])
                            </div>

                            <div class="col-md-12">
                                <p class="red-text" id="demo"></p>
                            </div>

                        </div>
                        <div class="card-action">
                            <button style="background-color: #1e2945 !important;" class="waves-effect waves-light btn center-block half blue" type="submit">
                                ثبت کد
                            </button>

                            <a class="waves-effect waves-light btn center-block half blue mt10" href="{{route('auth.confirm.sms')}}">ارسال مجدد کد</a>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection


@push('scripts')

    <script>
        // Set the date we're counting down to
        @if(isset(session('confirmMobile')['expire']))
            var countDownDate = new Date('{{session('confirmMobile')['expire']}}').getTime();
        @else
            var countDownDate = new Date().getTime() + 120000;
        @endif

        // Update the count down every 1 second
        var x = setInterval(function() {

            // Get today's date and time
            var now = new Date().getTime();

            // Find the distance between now and the count down date
            var distance = countDownDate - now;

            // Time calculations for days, hours, minutes and seconds
            var days = Math.floor(distance / (1000 * 60 * 60 * 24));
            var hours = Math.floor((distance % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
            var minutes = Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60));
            var seconds = Math.floor((distance % (1000 * 60)) / 1000);

            // Output the result in an element with id="demo"
            document.getElementById("demo").innerHTML =  minutes + " دقیقه " + seconds + " ثانیه " + ' تا پایان اعتبار کد.';

            // If the count down is over, write some text
            if (distance < 0) {
                clearInterval(x);
                document.getElementById("demo").innerHTML = "منقضی شد";
            }
        }, 1000);
    </script>
@endpush
