<!doctype html>
<html lang="fa">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>{{env('APP_NAME')}}</title>
    <link href="https://fonts.googleapis.com/icon?family=Material+Icons" rel="stylesheet">
    <link rel="stylesheet" href="{{asset('assets/css/master1.min.css')}}">
    <link rel="stylesheet" href="{{asset('assets/css/front1.css')}}">
    <link rel="shortcut icon" href="{{asset('assets/img/logo/AFCclub.png')}}"/>

    @stack('styles')
</head>

<body>

<div class="top-menu">
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-12 text-center">
                <img src="{{asset('assets/img/logo/logo_s.png')}}" alt="">
            </div>
            <!--<div class="col-md-12 text-left">-->
            <!--    <img class="margin12" src="{{asset('assets/img/logo/cinvu_logo.png')}}" alt="">-->
            <!--</div>-->
        </div>
    </div>
</div>

<nav class="navbar navbar-default navbar-sticky bootsnav">

    <!-- Start Top Search -->
    <div class="top-search">
        <div class="container">
            <div class="input-group">
                <span class="input-group-addon"><i class="fa fa-search"></i></span>
                <input type="text" class="form-control" placeholder="Search">
                <span class="input-group-addon close-search"><i class="fa fa-times"></i></span>
            </div>
        </div>
    </div>
    <!-- End Top Search -->

    <div class="container-fluid">

        <!-- Start Header Navigation -->
        <div class="navbar-header">
            <button type="button" class="navbar-toggle" data-toggle="collapse" data-target="#navbar-menu">
                <i class="fa fa-bars"></i>
            </button>
            {{--            <a class="navbar-brand" href="{{url('/')}}"><img src="{{asset('assets/img/logo/emi.png')}}" class="logo" alt=""></a>--}}
        </div>

        <div class="navbar-header left">
            {{-- <a class="navbar-brand navbar-brand-left" href="#"><img src="{{asset('assets/img/logo/cinvu_logo.png')}}" class="logo " alt=""></a>--}}
        </div>
        <!-- End Header Navigation -->

        <!-- Collect the nav links, forms, and other content for toggling -->
        <div class="collapse navbar-collapse" id="navbar-menu">
            <ul class="nav navbar-nav navbar-right" data-in="fadeInDown" data-out="fadeOutUp">

                <li class="active">
                    <a href="{{route('front.home')}}">
                        <i class="fa fa-home" aria-hidden="true"></i>
                        صفحه اصلی
                    </a>
                </li>

                @if(auth()->guest())
                    <li class="dropdown">
                        <a href="#" class="dropdown-toggle" data-toggle="dropdown" >
                            <i class="fa fa-archive" aria-hidden="true"></i>
                            عضویت
                        </a>
                        <ul class="dropdown-menu">
                            <li><a href="{{route('auth.register.create')}}">عضویت آموزشگاه</a></li>
                            <li><a href="{{route('auth.register.create')}}">عضویت افراد</a></li>
                        </ul>
                    </li>
                @endif


                <li class="dropdown">
                    <a href="#" class="dropdown-toggle" data-toggle="dropdown" >
                        <i class="fa fa-archive" aria-hidden="true"></i>
                        استعلام
                    </a>
                    <ul class="dropdown-menu">
                        <li><a href="{{route('front.inquiry.cervicecard.show',['type'=>'agencies'])}}">نمایندگی ها</a></li>
                        <li><a href="{{route('front.inquiry.cervicecard.show',['type'=>'schools'])}}">باشگاههای ورزشی</a></li>
                        <li><a href="{{route('front.inquiry.cervicecard.show',['type'=>'specialists'])}}">آموزش های فنی و حرفهای</a></li>
                        <li><a href="{{route('front.inquiry.cervicecard.show',['type'=>'languageEducation'])}}"> آموزشگاههای زبان</a></li>
                        <li><a href="{{route('front.inquiry.cervicecard.show',['type'=>'freeEducation'])}}">آموزشگاههای علمی آزاد</a></li>
                        <li><a href="{{route('front.inquiry.cervicecard.show',['type'=>'members'])}}">اعضا</a></li>
                    </ul>
                </li>

                <li class="dropdown">
                    <a href="#" class="dropdown-toggle" data-toggle="dropdown" >
                        <i class="fa fa-archive" aria-hidden="true"></i>
                        خدمات
                    </a>
                    <ul class="dropdown-menu scrollspy-custom">

                        @foreach(\App\Models\Service\serviceDepartment::validate()->with('category')->get() as $department)
                            <li class="dropdown">
                                <a href="#" class="dropdown-toggle" data-toggle="dropdown" >{{$department->title}}</a>
                                <ul class="dropdown-menu">
                                    @foreach($department->category as $category)
                                        @if($category->body)
                                            <li><a href="{{route('front.serviceCategory.show',$category->id)}}">{{$category->title}}</a></li>
                                        @else
                                            <li><a href="{{url('/panel/user/home')}}">{{$category->title}}</a></li>
                                        @endif
                                    @endforeach
                                </ul>
                            </li>
                        @endforeach

                    </ul>
                </li>

                <li>
                    <a href="{{route('front.serviceCategory.index')}}">
                        <i class="fa fa-ticket" aria-hidden="true"></i>
                        تخفیف های ویژه
                    </a>
                </li>

                <li>
                    <a href="{{route('front.request.index')}}">
                        <i class="fa fa-user" aria-hidden="true"></i>
                        درخواست همکاری
                    </a>
                </li>

                <li class="dropdown">
                    <a href="#" class="dropdown-toggle" data-toggle="dropdown" >
                        <i class="fa fa-users" aria-hidden="true"></i>
                        درباره ما
                    </a>
                    <ul class="dropdown-menu">
                        <li><a href="{{route('front.landing',urlencode('درباره-شبکه'))}}">درباره شبکه</a></li>
                        <li><a href="{{route('front.landing',urlencode('درباره-باشگاه'))}}">درباره باشگاه</a></li>
                        <li><a href="{{route('front.landing',urlencode('درباره-کانون'))}}">درباره کانون</a></li>
                        <li><a href="{{route('front.landing',urlencode('درباره-شورا'))}}">درباره شورا</a></li>
                        <li><a href="{{route('front.landing',urlencode('تماس-با-ما'))}}">تماس با ما</a></li>
                    </ul>
                </li>

                @if(auth()->guest())
                    <li>
                        <a href="{{route('auth.login')}}">
                            <i class="fa fa-user" aria-hidden="true"></i>
                            ورود
                        </a>
                    </li>
                @else
                    <li>
                        <a href="{{route('user.home')}}">
                            <i class="fa fa-user" aria-hidden="true"></i>
                            پنل کاربری
                        </a>
                    </li>

                    <li>
                        <a href="#" onclick="event.preventDefault();document.getElementById('logout-form').submit();">
                            <i class="fa fa-sign-out" aria-hidden="true"></i>
                            خروج
                        </a>
                        <form id="logout-form" action="{{ route('auth.logout') }}" method="POST" style="display: none;">
                            {{ csrf_field() }}
                        </form>
                    </li>
                @endif

            </ul>
        </div><!-- /.navbar-collapse -->
    </div>
</nav>


<div class="clearfix"></div>
<br>
@yield('content')
<div class="clearfix mb40"></div>
<footer>
    <div class="footer">
        <div class="container text-center">

            <div class="col-md-4">
                <img class=" mt40 hg200" src="{{asset('assets/img/logo/AFCclub.png')}}" alt="">
            </div>
            <div class="col-md-4">
                <h4 class="text-center mb20">نقشه دسترسی</h4>
                <a target="_blank" href="https://www.google.com/maps/place/35%C2%B048'04.1%22N+51%C2%B030'08.3%22E/@35.8011393,51.5001093,17z/data=!3m1!4b1!4m13!1m6!3m5!1s0x3f8e0539c73fd9eb:0x375d8b2ec9ba9e1!2sCINVU!8m2!3d35.8009696!4d51.5022874!3m5!1s0x0:0x0!7e2!8m2!3d35.8011349!4d51.5022981?hl=en">
                    <img class="img-responsive" src="{{asset('assets/img/googlemap.png')}}" alt="">
                </a>
            </div>
            <div class="col-md-4">
                <h4 class="text-center mb20">اطلاعات تماس</h4>
                <p>میدان ونک-گاندی شمالی پلاک 4 واحد 4 </p>
                <p>
                    <i class="fa fa-phone" aria-hidden="true"></i>
                    تلفن: 88887875 21 98+
                </p>
                <i class="fa fa-paper-plane" aria-hidden="true"></i>
                <a href="mailto:info@emigroup.ir">info@afc-club.ir</a>
            </div>
{{--            <div class="col-md-3">--}}
{{--                <h4 class="text-center mb20">نماد اعتماد</h4>--}}
{{--                <a href="https://trustseal.enamad.ir/?id=141168&amp;Code=MPGnFkMNJdwcRbhBZl2s" target="_blank" rel="noopener noreferrer"><img class="lazy-loaded" id="MPGnFkMNJdwcRbhBZl2s" style="cursor: pointer;" src="https://trustseal.enamad.ir/Content/Images/Star/star1.png?v=5.0.0.46" data-lazy-type="image" data-src="https://trustseal.enamad.ir/Content/Images/Star/star1.png?v=5.0.0.46" alt=""></a>--}}
{{--            </div>--}}

        </div>
    </div>
    <div>
        <div class="footer2">
            <h4 class="text-center">تمام حقوق اين سايت محفوظ و متعلق به سامانه تیم مي باشد.</h4>
        </div>
    </div>
</footer>

<script src="{{asset('assets/js/master.min.js')}}"></script>
<script src="{{asset('assets/js/master.js')}}"></script>
@include('share.extra.sweetalert')
@stack('scripts')

</body>
</html>
