<!doctype html>
<html lang="fa">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>{{env('APP_NAME')}}</title>
    <link href="https://fonts.googleapis.com/icon?family=Material+Icons" rel="stylesheet">
    <link rel="stylesheet" href="{{asset('assets/css/master.min.css')}}">
    <link rel="stylesheet" href="{{asset('assets/css/front.css')}}">
    <link rel="shortcut icon" href="{{asset('assets/img/fav.png')}}"/>

    @stack('styles')
</head>

<body>

<div class="top-menu">
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-4 text-right">
                <img src="{{asset('assets/img/master/sazman.png')}}" alt="">
            </div>
            <div class="col-md-6 mt40 text-left">
                <a class="ml20" href="">ورود</a>
                <a class="ml20" href="">عضویت به عنوان متخصص</a>
            </div>
        </div>
    </div>
</div>

<nav class="navbar navbar-default navbar-sticky bootsnav">

    <!-- Start Top Search -->
    <div class="top-search">
        <div class="container">
            <div class="input-group">
                <span class="input-group-addon"><i class="fa fa-search"></i></span>
                <input type="text" class="form-control" placeholder="Search">
                <span class="input-group-addon close-search"><i class="fa fa-times"></i></span>
            </div>
        </div>
    </div>
    <!-- End Top Search -->

    <div class="container-fluid">

        <!-- Start Header Navigation -->
        <div class="navbar-header">
            <button type="button" class="navbar-toggle" data-toggle="collapse" data-target="#navbar-menu">
                <i class="fa fa-bars"></i>
            </button>
{{--            <a class="navbar-brand" href="{{url('/')}}"><img src="{{asset('assets/img/logo/emi.png')}}" class="logo" alt=""></a>--}}
        </div>

        <div class="navbar-header left">
{{--            <a class="navbar-brand navbar-brand-left" href="#"><img src="{{asset('assets/img/logo/sazman.png')}}" class="logo sazman" alt=""></a>--}}
{{--            <a class="navbar-brand navbar-brand-left" href="#"><img src="{{asset('assets/img/logo/iran.svg')}}" class="logo " alt=""></a>--}}
        </div>
        <!-- End Header Navigation -->

        <!-- Collect the nav links, forms, and other content for toggling -->
        <div class="collapse navbar-collapse" id="navbar-menu">
            <ul class="nav navbar-nav navbar-right" data-in="fadeInDown" data-out="fadeOutUp">

                <li class="active">
                    <a href="{{route('front.home')}}">
                        <i class="fa fa-home" aria-hidden="true"></i>
                        صفحه اصلی
                    </a>
                </li>

                <li class="dropdown">
                    <a href="#" class="dropdown-toggle" data-toggle="dropdown" >
                        <i class="fa fa-archive" aria-hidden="true"></i>
                        خدمات
                    </a>
                    <ul class="dropdown-menu scrollspy-custom">

                        @foreach(\App\Models\Service\serviceDepartment::validate()->with('category')->get() as $department)
                            <li class="dropdown">
                                <a href="#" class="dropdown-toggle" data-toggle="dropdown" >{{$department->title}}</a>
                                <ul class="dropdown-menu">
                                    @foreach($department->category as $category)
                                        @if($category->body)
                                            <li><a href="{{route('front.serviceCategory.show',$category->id)}}">{{$category->title}}</a></li>
                                        @else
                                            <li><a href="{{url('/panel/user/home')}}">{{$category->title}}</a></li>
                                        @endif
                                    @endforeach
                                </ul>
                            </li>
                        @endforeach
                    </ul>
                </li>




                <li class="dropdown">
                    <a href="#" class="dropdown-toggle" data-toggle="dropdown" >
                        <i class="fa fa-archive" aria-hidden="true"></i>
                        استعلام
                    </a>
                    <ul class="dropdown-menu">
                        <li><a href="{{route('front.inquiry.cervicecard.show',['type'=>'agencies'])}}">نمایندگی ها</a></li>
{{--                        <li><a href="{{route('front.inquiry.cervicecard.show',['type'=>'schools'])}}">آموزشگاه ها</a></li>--}}
                        <li><a href="{{route('front.inquiry.cervicecard.show',['type'=>'specialists'])}}">متخصصین</a></li>
                    </ul>
                </li>

                <li class="dropdown">
                    <a href="#" class="dropdown-toggle" data-toggle="dropdown" >
                        <i class="fa fa-users" aria-hidden="true"></i>
                        درباره ما
                    </a>
                    <ul class="dropdown-menu">
                        <li><a href="{{route('front.landing',urlencode('درباره-سازمان-متخصصین'))}}">درباره سازمان متخصصین</a></li>
                        <li><a href="{{route('front.landing',urlencode('درباره-باشگاه'))}}">درباره باشگاه</a></li>
                        <li><a href="{{route('front.landing',urlencode('منشور-اخلاقی-باشگاه'))}}">منشور اخلاقی باشگاه</a></li>
                        <li><a href="{{route('front.landing',urlencode('تماس-با-ما'))}}">تماس با ما</a></li>
                    </ul>
                </li>

                <li>
                    <a href="{{route('front.serviceCategory.index')}}">
                        <i class="fa fa-ticket" aria-hidden="true"></i>
                        تخفیف های ویژه
                    </a>
                </li>
                <li>
                    <a href="{{route('front.request.index')}}">
                        <i class="fa fa-user" aria-hidden="true"></i>
                        درخواست همکاری
                    </a>
                </li>

                @if(auth()->guest())
                    <li>
                        <a href="{{route('auth.register.create')}}">
                            <i class="fa fa-sign-in" aria-hidden="true"></i>
                            عضویت
                        </a>
                    </li>
                    <li>
                        <a href="{{route('auth.login')}}">
                            <i class="fa fa-sign-in" aria-hidden="true"></i>
                            ورود
                        </a>
                    </li>
                @else
                    <li>
                        <a href="{{route('user.home')}}">
                            <i class="fa fa-user" aria-hidden="true"></i>
                            پنل کاربری
                        </a>
                    </li>
                    <li>
                        <a href="{{route('user.home')}}" onclick="event.preventDefault();document.getElementById('logout-form').submit();">
                            <i class="fa fa-user" aria-hidden="true"></i>
                            خروج
                        </a>

                        <form id="logout-form" action="{{ route('auth.logout') }}" method="POST" style="display: none;">
                            {{ csrf_field() }}
                        </form>
                    </li>
                @endif


            </ul>
        </div><!-- /.navbar-collapse -->
    </div>
</nav>


<div class="clearfix"></div>
<br>
@yield('content')
<div class="clearfix mb40"></div>
<footer>
    <div class="footer">
        <div class="container">

            <div class="col-md-3">
                <img class="img-responsive mt40" src="{{asset('assets/img/logo/emi.png')}}" alt="">
            </div>
            <div class="col-md-3">
                <h4 class="text-center mb20">نقشه دسترسی</h4>
                <a target="_blank" href="https://www.google.com/maps?ll=35.796917,51.418639&z=17&t=m&hl=en&gl=US&mapclient=embed">
                    <img class="img-responsive" src="{{asset('assets/img/googlemap.png')}}" alt="">
                </a>
            </div>
            <div class="col-md-3">
                <h4 class="text-center mb20">اطلاعات تماس</h4>
                <p>ایران، تهران، خیابان ولیعصر، بالاتر از پارک وی، خیابان خیام، خیابان کامران، پلاک 10، طبقه 2</p>
                <p>
                    <i class="fa fa-phone" aria-hidden="true"></i>
                    02126294350
                </p>

                <p>
                    <i class="fa fa-phone" aria-hidden="true"></i>
                    02126294597
                </p>

                <i class="fa fa-paper-plane" aria-hidden="true"></i>
                <a href="mailto:info@emigroup.ir">info@emigroup.ir</a>
            </div>
            <div class="col-md-3">
                <h4 class="text-center mb20">نماد اعتماد</h4>
                <a href="https://trustseal.enamad.ir/?id=141168&amp;Code=MPGnFkMNJdwcRbhBZl2s" target="_blank" rel="noopener noreferrer"><img class="lazy-loaded" id="MPGnFkMNJdwcRbhBZl2s" style="cursor: pointer;" src="https://trustseal.enamad.ir/Content/Images/Star/star1.png?v=5.0.0.46" data-lazy-type="image" data-src="https://trustseal.enamad.ir/Content/Images/Star/star1.png?v=5.0.0.46" alt=""></a>
            </div>

        </div>
    </div>
    <div>
        <div class="footer2">
            <h4 class="text-center">تمام حقوق اين سايت محفوظ و متعلق به تیم متخصصین مي باشد.</h4>
        </div>
    </div>
</footer>

<script src="{{asset('assets/js/master.min.js')}}"></script>
<script src="{{asset('assets/js/master.js')}}"></script>
@include('share.extra.sweetalert')
@stack('scripts')

</body>
</html>
