@extends('front.layouts.master')


@section('content')
    <div class="skillpage mt40 mb40">

        <div class="container service-category">

            <div class="row">

                @foreach($categories->chunk(4) as $chunk)
                    @foreach($chunk as $category)
                        <div class="col-md-3 col-sm-6 col-xs-12">

                            <div class="card small box-shadow pd20">
                                <div class="card-image waves-effect waves-block waves-light">
                                    <img class="img-responsive" src="{{$category->pictureApi}}">
                                </div>
                                <div class="card-content text-center">
                                    <span class="card-title activator grey-text text-darken-4 text-center">{{$category->title}}</span>
                                </div>
                                <div class="card-action text-center">
                                    <a class="waves-effect waves-light custom-btn text-center" href="{{route('front.serviceOffer.index',['category_id'=>$category->id])}}">مشاهده‌‌ی هدیه</a>
                                </div>
                            </div>

                        </div>
                    @endforeach
                    <div class="col-xs-12 mt20"></div>
                @endforeach

            </div>

            <div class="row">
                <div class="col-md-12">
                    {!! $categories->links() !!}
                </div>
            </div>

        </div>

    </div>
@endsection

@push('scripts')

    <script type="text/javascript">
        $(document).ready(function(){
            $('.modal').modal();
        });
    </script>

@endpush
