@extends('user.layout.master')

@section('content')
    <div class="row">
        <div class="col-md-12 ">
            <ol class="breadcrumb">
                <li><a href="{{route('user.home')}}">صفحه اصلی</a></li>
                <li><a href="{{route('user.tickets.index')}}">لیست پیام ها</a></li>
                <li class="active">ایجاد پیام</li>
            </ol>
        </div>
    </div>

    <form method="post" action="{{route('user.tickets.store')}}" enctype="multipart/form-data">
        {{ csrf_field() }}
        <div class="row white z-depth-1">
            <div class="col-md-12">
                <span class="blue-grey darken-2 white-text title z-depth-2">ایجاد تیکت</span>
                @include('share.extra.back2',['route'=>route('user.tickets.index')])
            </div>

            <div class="col-md-6">
                @include('share.forms.select',['name'=>'department_id','title'=>'انتخاب دپارتمان','options'=>$departments])
            </div>
            <div class="col-md-6">
                @include('share.forms.select',['name'=>'priority','title'=>'اولویت','options'=>['urgent'=>'فوری','high'=>'بالا','medium'=>'متوسط','low'=>'ضعیف']])
            </div>
            <div class="clearfix"></div>
            <div class="col-md-12">
                @include('share.forms.input',['name'=>'title','title'=>'تیتر'])
            </div>
            <div class="col-md-12">
                @include('share.forms.textarea-Material',['name'=>'body','title'=>'متن'])
            </div>
            <div class="col-md-6">
                @include('share.forms.file',['name'=>'file','title'=>'آپلود فایل'])
            </div>

            <div class="col-md-12 mb20 mt20">
                <button class="waves-effect waves-light btn quarter center-block blue darken-1">ذخیره</button>
            </div>

        </div>
    </form>
@endsection

@push('scripts')

    <script>
        $(document).ready(function () {
            $('select').material_select();
        });
    </script>

@endpush