@extends('admin.layout.master')

@section('content')
    <form method="post" action="{{route('tickets.update',$ticket->id)}}" enctype="multipart/form-data">
        {{ method_field('PUT') }}
        {{ csrf_field() }}
        <div class="row white z-depth-1">
            <div class="col-md-12">
                <span class="blue-grey darken-2 white-text title z-depth-2">ویرایش پیام</span>
            </div>

            <div class="col-md-6">
                <label for="">انتخاب دپارتمان پیام</label>
                <multiselect v-model="departmentSelected" :options="departments" label="title" track-by="id" :internal-search="false"></multiselect>
                @include('share.forms.error',['name'=>'department_id'])
            </div>
            <div class="col-md-6">
                <label for="">انتخاب کاربر</label>
                <multiselect v-model="userSelected" :options="users" :custom-label="customLabel" label="lastName" track-by="id" :internal-search="false" @search-change="usersSearch"></multiselect>
                @include('share.forms.error',['name'=>'user_id'])
            </div>
            <div class="clearfix mb20"></div>
            <div class="col-md-12 mb20">
                <label for="">ارجاع به مدیران</label>
                <multiselect v-model="adminSelected" :options="admins" :custom-label="customLabel"
                             label="lastName" track-by="id" :searchable="true" :multiple="true"
                             :close-on-select="false" :clear-on-select="false"
                             :internal-search="false" @search-change="adminsSearch"></multiselect>
                @include('share.forms.error',['name'=>'admins_id'])
            </div>
            <div class="col-md-12">
                @include('share.forms.input',['name'=>'title','title'=>'تیتر','value'=>$ticket->title])
            </div>
            <div class="col-md-6">
                @include('share.forms.select',['name'=>'priority','title'=>'اولویت','options'=>['urgent'=>'فوری','high'=>'بالا','medium'=>'موتسط','low'=>'پایین'],'selected'=>$ticket->priority])
            </div>
            <div class="col-md-6">
                @include('share.forms.select',['name'=>'status','title'=>'وضعیت','options'=>['open'=>'باز','pending'=>'در حال بررسی','close'=>'بستن','deactive'=>'غیر فعال'],'selected'=>$ticket->status])
            </div>
            <div class="col-md-12">
                @include('share.forms.textarea-Material',['name'=>'body','title'=>'متن','value'=>$ticket->body])
            </div>
            <div class="col-md-6">
                @include('share.forms.file',['name'=>'file','title'=>'آپلود فایل'])
            </div>
            @if($ticket->pathFile)
                <div class="col-md-6 mt20 text-center">
                    <a class="waves-effect waves-light btn" href="{{asset($ticket->pathFile)}}" download><i class="material-icons right">attach_file</i>دانلود فایل</a>
                </div>
            @endif

            <div class="col-md-12 mb20 mt20">
                <button class="waves-effect waves-light btn quarter center-block blue-grey darken-2">ذخیره</button>
            </div>
            <div>
                <input type="hidden" id="department_id" name="department_id" value="{{$ticket->ticketDepartment_id}}">
                <input type="hidden" id="user_id" name="user_id" value="{{$ticket->user_id}}">
                <input type="hidden" id="admins_id" name="admins_id" value="{{$ticket->referer->pluck('id')}}">
            </div>

        </div>
    </form>
    @include('share.extra.back',['route'=>route('tickets.index')])
@endsection

@push('scripts')
    <script src="{{asset('assets/plugins/vueselect/vueselect.js')}}"></script>

    <script>
        $(document).ready(function () {
            $('select').material_select();
        });

        Vue.component('Multiselect', VueMultiselect.default);
        new Vue({
            el:'#app',
            data:{
                ax:axios.create({headers:{'Authorization':'Bearer {{auth()->user()->api_token}}'}}),

                departments:[],
                departmentSelected:{!! $departments !!},

                users:[{!! $ticket->user !!}],
                userSelected:{!! $ticket->user !!},

                admins:{!! $ticket->referer !!},
                adminSelected:{!! $ticket->referer !!}

            },
            created:function () {
                this.ax.post('/api/v1/ticket/ticketdepartment',{}).then(function (response) {
                    this.departments = response.data;
                }.bind(this));
            },
            methods:{
                usersSearch:function (query) {
                    if (query !== '') {
                        this.ax.post('/api/admin/user/users',{query:query}).then(function (response) {
                            this.users = response.data;
                        }.bind(this));
                    }
                },
                adminsSearch:function (query) {
                    if (query !== '') {
                        this.ax.post('/api/admin/user/users',{query:query}).then(function (response) {
                            this.admins = response.data;
                        }.bind(this));
                    }
                },
                customLabel:function (item) {
                    return item.firstName + ' ' + item.lastName;
                },
            },
            watch:{
                departmentSelected:function () {
                    document.getElementById('department_id').value = this.departmentSelected.id;
                },
                userSelected:function () {
                    document.getElementById('user_id').value = this.userSelected.id;
                },
                adminSelected:function () {
                    var output = [];
                    for (var i=0; i < this.adminSelected.length ; i++){
                        output.push(this.adminSelected[i]['id']);
                    }
                    document.getElementById('admins_id').value = JSON.stringify(output);
                },
            }
        });
    </script>

@endpush

@push('styles')
    <link rel="stylesheet" href="{{asset('assets/plugins/vueselect/vueselect.css')}}">
@endpush