@extends('user.layout.master')

@section('content')

    <div class="row panel-user">


        @if(auth()->user()->isPay && auth()->user()->isActive)
            <div>
                <div class="col-md-12 section-1">
                    <div class="card">
                        <div class="card-tabs">
                            <ul class="tabs tabs-fixed-width">
                                <li class="tab active"><a href="#test0">وضعیت</a></li>

                                @if(isset($organization->id))
                                    <li class="tab active"><a href="#referalCode">کد معرف</a></li>
                                @endif


                                @foreach($departments as $department)
                                    <li class="tab"><a href="#test{{$department->id}}">{{$department->title}}</a></li>
                                @endforeach
                            </ul>
                        </div>
                        <div class="card-content grey lighten-4 col-md-12">

                            <div class="userstatus" id="test0">

                                <div>
                                    {{--                            <div class="col-md-12 userstatusLine"></div>--}}

                                    <div class="col-md-2 text-center">

                                        <div class="col-md-12">
                                            <i class="fa fa-check-circle-o circle-checked" aria-hidden="true"></i>
                                        </div>
                                        <p class="col-md-12">
                                            در انتظار
                                        </p>
                                    </div>

                                    @foreach($serviceCardStatus as $status)
                                        <div class="col-md-2 text-center">
                                            <div class="col-md-12">
                                                @if($serviceCardStatusUser->where('id',$status->id)->first())
                                                    <i class="fa fa-check-circle-o circle-checked" aria-hidden="true"></i>
                                                @else
                                                    <p class="circle"></p>
                                                @endif
                                            </div>
                                            <p class="col-md-12">{{$status->title}}</p>
                                        </div>
                                    @endforeach
                                </div>

                                <div class="col-md-12 mt40">
                                    <div class="col-md-4">
                                        <img class="img-responsive" src="{{asset('assets/img/cardsfull.png')}}" alt="">
                                    </div>
                                    <div class="col-md-8">
                                        <div class="col-md-3">
                                            <span>نام: </span>
                                            <span>{{auth()->user()->firstName}}</span>
                                        </div>
                                        <div class="col-md-3">
                                            <span>نام خانوادگی: </span>
                                            <span>{{auth()->user()->firstName}}</span>
                                        </div>
                                        <div class="col-md-3">
                                            <span>تاریخ تولد: </span>
                                            <span>{{toPersian(auth()->user()->birthday)}}</span>
                                        </div>
                                        <div class="col-md-3">
                                            <span>کد ملی: </span>
                                            <span>{{auth()->user()->nationalCode}}</span>
                                        </div>
                                        <div class="clearfix"></div>
                                    </div>
                                </div>
                            </div>

                            @if(isset($organization->id))
                                <div class="userstatus" id="referalCode">
                                    <div class="col-md-6">
                                        <h4>کد معرف سازمان:</h4>
                                        <h4>emi_{{$organization->id}}</h4>
                                        <h4>تعداد فروش {{$organization->title}}:</h4>
                                        <h4>
                                            @if(isset($organization->id))
                                                {{$organization->userReferal()->count()}}
                                            @endif
                                        </h4>
                                    </div>
                                </div>
                            @endif


                            @foreach($departments as $department)
                                <div class="col-md-12 body-tabs" id="test{{$department->id}}">
                                    <div class="owl-carousel owl-theme">
                                        @foreach($department->category as $category)
                                            <div class="col-md-12 pdl0 pdr10">
                                                <div class="card small box-shadow">
                                                    <div class="card-image waves-effect waves-block waves-light">
                                                        <img class="img-responsive" src="{{$category->pictureApi}}">
                                                    </div>
                                                    <div class="card-content text-center">
                                                        <span class="card-title activator grey-text text-darken-4 text-center">{{$category->title}}</span>
                                                    </div>

                                                    @if($category->offer()->validate()->count() > 0)
                                                        <div class="text-center">
                                                            <a class="waves-effect waves-light custom-btn text-center" href="#modal_{{$loop->index.$department->id}}">زیر مجموعه</a>
                                                        </div>
                                                    @endif

                                                </div>
                                            </div>
                                        @endforeach
                                    </div>
                                </div>
                            @endforeach


                            @foreach($departments as $department)
                                @foreach($department->category as $category)
                                    <div id="modal_{{$loop->index.$department->id}}" class="modal">
                                        <div class="modal-content">

                                            @foreach($category->offer()->validate()->get() as $offer)
                                                <div class="col-md-3">
                                                    <div class="card medium">
                                                        <div class="card-image waves-effect waves-block waves-light">
                                                            <img class="img-responsive" src="{{asset($offer->pictureApi)}}">
                                                        </div>
                                                        <div class="card-content text-center text-center">
                                                            <span class="card-title activator grey-text text-darken-4 text-center">{{$offer->title}}</span>
                                                        </div>
                                                        <div class="card-action text-center">
                                                            <a class="waves-effect waves-light custom-btn" target="_blank" href="{{route('front.serviceOffer.click',$offer->id)}}">ورود به سایت</a>
                                                        </div>
                                                    </div>
                                                </div>
                                            @endforeach

                                        </div>
                                    </div>
                                @endforeach
                            @endforeach

                        </div>
                    </div>
                </div>

                <div class="col-md-12">
                    <div class="card-panel col-md-12">
                        <div class="col-md-12 department-title">
                            <h4>تخفیف ها</h4>
                        </div>
                        <div class="col-md-12 mt20"></div>

                        <div class="row ">
                            @foreach($offerDiscounts->chunk(3) as $chunk)
                                @foreach($chunk as $discount)
                                    <div class="col-md-4 col-sm-6 col-xs-12">
                                        <div class="ticket col-xs-12 pd0">
                                            <div class="ticket-card ticket-right col-xs-4">
                                                <img class="img-responsive" src="{{asset($discount->pictureApi)}}" alt="">
                                            </div>
                                            <div class="ticket-card ticket-left col-xs-8 pd0">
                                                <div class="col-xs-12 mt10 ticket-title">{{$discount->title}}</div>
                                                <div class="col-xs-12 pd10 red waves-effect waves-light mt10 discount_code_copy">
                                                    <div class="col-xs-7 white-text discount_code">
                                                        {{$discount->code}}
                                                    </div>
                                                    <div class="col-xs-5 pd0 text-left">
                                                        <a class="white-text copy-button">کپی کنید</a>
                                                    </div>
                                                </div>
                                                <div class="col-xs-12 mt10">
                                                    <p>
                                                        <span>مهلت استفاده تا </span>
                                                        <span>{{toPersian($discount->expire)}}</span>
                                                    </p>
                                                </div>
                                                <div class="col-xs-12 mt10 mb10 text-right">
                                                    <a class=" waves-effect waves-light custom-btn2 white text-right" target="_blank" href="{{$discount->link}}">ورود به سایت</a>

                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                @endforeach
                                <div class="col-xs-12 mt20"></div>
                            @endforeach
                        </div>

                    </div>
                </div>
            </div>
        @elseif(!auth()->user()->isPay)
            <br><br><br><br><br>
            <div class="col-md-12 text-center ">
                <div class="col-md-2"></div>
                <div class="col-md-8  pd10 card">
                    <img style="height: 400px;margin: auto" class="text-center img-responsive" src="{{asset('assets/img/payment.png')}}" alt="">
                    <h2 class="text-center">لطفا اقدام به پرداخت نمایید</h2>
                    <a href="{{route('user.order.service.serviceCardPay')}}" class="waves-effect waves-light btn center-block quarter green">پرداخت مبلغ</a>
                </div>
            </div>
        @else
            <br><br><br><br><br>
            <div class="col-md-12 text-center">
                <div class="col-md-2"></div>
                <div class="col-md-8  pd10 card">
                    <img style="height: 400px;margin: auto" class="text-center img-responsive" src="{{asset('assets/img/complete-profile.svg')}}" alt="">
                    <h1 class="text-center">لطفا جهت تکمیل پروفایل خود اقدام کنید</h1>
                    <p> پس از تکمیل پروفایل کارت شما صادر خواهد شد</p>
                    <a href="{{route('user.profile.edit')}}" class="waves-effect waves-light btn center-block quarter green mt20">تکمیل پروفایل</a>
                </div>
            </div>
        @endif


    </div>

@endsection


@push('scripts')
    <script src="{{asset('assets/plugins/owlCarousel/owl.carousel.min.js')}}"></script>
    <script src="{{asset('assets/plugins/toaster/toastr.min.js')}}"></script>


    <script type="text/javascript">
        function copyToClipboard(element) {
            var $temp = $("<input>");
            $("body").append($temp);
            $temp.val($(element).text()).select();
            document.execCommand("copy");
            $temp.remove();
        }


        $(document).ready(function(){
            $('.modal').modal();

            $(".discount_code_copy").click(function () {
                var discount_code = $(this).find('.discount_code');
                copyToClipboard(discount_code);

                toastr.options = {
                    "closeButton": true,
                    "debug": false,
                    "newestOnTop": false,
                    "progressBar": true,
                    "positionClass": "toast-bottom-right",
                    "preventDuplicates": false,
                    "onclick": null,
                    "showDuration": "300",
                    "hideDuration": "1000",
                    "timeOut": "5000",
                    "extendedTimeOut": "1000",
                    "showEasing": "swing",
                    "hideEasing": "linear",
                    "showMethod": "fadeIn",
                    "hideMethod": "fadeOut"
                }
                toastr["success"]("کپی شد");
            });

            $('.owl-carousel').owlCarousel({
                rtl: true,
                loop:true,
                margin:10,
                nav:false,
                autoplay:true,
                autoplayTimeout:2000,
                autoplayHoverPause:true,
                responsive:{
                    0:{
                        items:1
                    },
                    600:{
                        items:3
                    },
                    1000:{
                        items:5
                    }
                }
            });



        });


    </script>

@endpush

@push('styles')
    <link rel="stylesheet" href="{{asset('assets/plugins/owlCarousel/owl.carousel.min.css')}}">
    <link rel="stylesheet" href="{{asset('assets/plugins/owlCarousel/owl.theme.default.min.css')}}">
    <link rel="stylesheet" href="{{asset('assets/plugins/toaster/toastr.min.css')}}">

    <style>
        .panel-user .tabs .tab a.active, .tabs .tab a:hover {
            color: #3c3c3c;
        }
        .panel-user .tabs .tab a {
            color: #c8c8c8;
        }

        .panel-user .tabs .indicator {
            background-color: #282396 !important;
        }

        /*.user-panel .section-1 .card{*/
        /*    box-shadow: 0 0 10px 0 rgba(0, 0, 0, 0.1);*/
        /*}*/

        .panel-user .box-shadow {
            box-shadow: 0 0 10px 0 rgba(0, 0, 0, 0.1) !important;
        }


        .modal {
            width: 88% !important;
        }
        .card-image{
            padding: 50px !important;
        }
        .card .card-image img {
            width: auto;
            max-height: 150px;
            text-align: center;
            display: block;
            margin: auto;
        }



    </style>
@endpush
