@extends('user.layout.master')

@section('content')
    <div class="row">
        <div class="col-md-12 ">
            <ol class="breadcrumb">
                <li><a href="{{route('user.home')}}">صفحه اصلی</a></li>
                <li class="active">تغییر گذرواژه</li>
            </ol>
        </div>
    </div>

    <form method="post" action="{{route('user.profile.changepassword.ResetPasswordUpdate')}}" enctype="multipart/form-data">
        <input type="hidden" name="_method" value="PUT">
        {{ csrf_field() }}
        <div class="row white z-depth-1">
{{--            <div class="col-md-12">--}}
{{--                <span class="blue-grey darken-2 white-text title z-depth-2">تغییر گذرواژه</span>--}}
{{--            </div>--}}

            <div class="col-md-12">
                @include('share.forms.input',['name'=>'password','class'=>'dleft','title'=>'رمز جدید'])
            </div>

            <div class="col-md-12">
                @include('share.forms.input',['name'=>'password_confirmation','class'=>'dleft','title'=>'تکرار رمز'])
            </div>


            <div class="clearfix mt20"></div>
            <div class="col-md-12 mb20 mt20 ">
                <button class="waves-effect waves-light btn quarter center-block blue darken-2">ذخیره</button>
            </div>
        </div>
    </form>
@endsection


@push('scripts')
    <script src="{{asset('assets/plugins/vueselect/vueselect.js')}}"></script>
    <script src="{{asset('assets/plugins/datePicker/persianDate.js')}}"></script>
    <script src="{{asset('assets/plugins/datePicker/datePicker.js')}}"></script>

    <script>
        $(document).ready(function () {
            $("#birthday").pDatepicker({
                format : "YYYY/MM/DD",
                maxDate: new persianDate().valueOf(),
                initialValueType: 'gregorian'
            });

            $("#birthday").val('{{toPersian(auth()->user()->birthday)}}')
            $('select').material_select();
        });

        Vue.component('Multiselect', VueMultiselect.default);
        new Vue({
            el: '#app',
            data: {
                ax:axios.create({baseURL: '/api',headers:{'Authorization':'Bearer {{auth()->user()->api_token}}'}}),

                role:{
                    url:'/v1/admin/acl/role',
                    list:{!! auth()->user()->role !!},
                    selected:{!! auth()->user()->role !!},
                    query:'',
                    data:[],
                    loading:false
                },

                nationalCode:'{{auth()->user()->nationalCode}}',
                validnationalCode:true
            },
            methods: {
                checkNationalCode: function (code) {
                    var L = code.length;

                    if (L < 8 || parseInt(code, 10) == 0) return false;
                    code = ('0000' + code).substr(L + 4 - 10);
                    if (parseInt(code.substr(3, 6), 10) == 0) return false;
                    var c = parseInt(code.substr(9, 1), 10);
                    var s = 0;
                    for (var i = 0; i < 9; i++)
                        s += parseInt(code.substr(i, 1), 10) * (10 - i);
                    s = s % 11;
                    return (s < 2 && c == s) || (s >= 2 && c == (11 - s));
                    return true;
                },

                roleLabel: function (element) {
                    return element.id+' - '+element.name;
                },
                search: function (query,field) {
                    if (query !== '') {
                        this.ax.get(this[field].url, {params:{query:query}}).then(function (response) {
                            this[field].query = query;
                            this[field].list = response.data.data;
                            this[field].data = response.data;
                        }.bind(this));
                    }
                },
                customLabel: function (element) {
                    return element.id+' - '+element.title;
                },
                isMoreResult:function (field) {
                    return (this[field].data.current_page+1 <= this[field].data.last_page);
                },
                moreResult:function (field) {
                    if (this.isMoreResult(field)) {
                        this[field].loading = true;
                        this.ax.get(this[field].url, {params:{query:this[field].query,page:(this[field].data.current_page+1)}}).then(function (response) {
                            this[field].list = this[field].list.concat(response.data.data);
                            this[field].data = response.data;
                            this[field].loading = false;
                        }.bind(this));
                    }
                }
            },
            watch: {
                'role.selected': function () {
                    var output = [];
                    for (var i=0; i < this.role.selected.length ; i++){
                        output.push(this.role.selected[i]['id']);
                    }
                    document.getElementById('roles_id').value = JSON.stringify(output);
                },
                nationalCode: function () {
                    if (this.nationalCode === '') {
                        this.validnationalCode = true;
                    } else {
                        this.validnationalCode = this.checkNationalCode(this.nationalCode);
                    }
                }
            }
        });
    </script>
@endpush

@push('styles')
    <link rel="stylesheet" href="{{asset('assets/plugins/vueselect/vueselect.css')}}">
    <link rel="stylesheet" href="{{asset('assets/plugins/datePicker/persianDatePicker.css')}}">
    <link rel="stylesheet" href="{{asset('assets/plugins/datePicker/custom.css')}}" />
@endpush