<?php

Route::get('home', 'panelController@index')->name('home');


// Tickets
Route::get('ticket/tickets/excel', 'Ticket\TicketController@excel');

Route::get('ticket/ticketmessages/messages/{id}', 'Ticket\TicketMessageController@indexMessage')->name('ticketmessages.indexMessage');
Route::resource('ticket/ticketdepartment', 'Ticket\ticketDepartmentController');
Route::resource('ticket/tickets', 'Ticket\TicketController');
Route::resource('ticket/ticketmessages', 'Ticket\TicketMessageController');

Route::get('ticket/group/filter', 'Ticket\TicketSendGroupFilterController@create')->name('ticket.group.filter');
Route::post('ticket/group/filter', 'Ticket\TicketSendGroupFilterController@store')->name('ticket.group.filterStore');


// Acl

Route::resource('roles', 'Acl\RoleController');
Route::resource('users', 'Acl\userController');
Route::get('user/excel', 'Acl\userController@excel');
Route::get('user/{user}/login', 'Acl\userController@login');
Route::get('user/{user}/changestatus', 'Acl\userController@changeStatus')->name('users.changeStatus');
Route::post('user/{user}/changestatus', 'Acl\userController@changeStatusStore')->name('users.changeStatusStore');


// Settings

Route::prefix('setting')->namespace('Setting')->group(function () {

    Route::get('settings/create', 'SettingController@create')->name('settings.create');
    Route::post('settings', 'SettingController@store')->name('settings.store');
    Route::resource('settingcategory', 'SettingCategoryAdminController');
    Route::resource('admin', 'SettingAdminController', ['as' => 'setting']);

});


// Region

Route::prefix('region')->name('region.')->namespace('Region')->group(function () {

    Route::resource('country', 'CountryController');
    Route::resource('state', 'StateController');
    Route::resource('city', 'CityController');
    Route::resource('area', 'AreaController');

});


Route::prefix('service')->namespace('Service')->name('service.')->group(function () {

    Route::resource('department', 'departmentController');
    Route::resource('category', 'categoryController');
    Route::resource('offer', 'offerController');
    Route::resource('card', 'cardController');
    Route::resource('cardstatus', 'cardStatusController');

});


Route::prefix('skill')->namespace('Skill')->name('skill.')->group(function () {

    Route::resource('skill', 'skillController');
    Route::resource('category', 'skillCategoryController');

});


Route::prefix('organization')->namespace('Organization')->name('organization.')->group(function () {

    Route::get('organization/users/{organization}', 'OrganizationController@refUsers')->name('organization');
    Route::resource('organization', 'OrganizationController');

});


Route::prefix('wallet')->namespace('Wallet')->name('wallet.')->group(function () {

    Route::resource('wallet', 'walletController');
    Route::resource('transaction', 'walletTransactionController');
    Route::resource('request', 'walletRequestController');

});


Route::prefix('academy')->namespace('Academy')->name('academy.')->group(function () {

    route::resource('agent', 'AgentController');
    route::resource('academy', 'AcademyController');
    route::resource('academytype', 'AcademyTypesController');


});

Route::group(['prefix' => 'cms-filemanager'], function () {
    \UniSharp\LaravelFilemanager\Lfm::routes();
});
