<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-md-12 ">
            <ol class="breadcrumb">
                <li><a href="<?php echo e(route('admin.home')); ?>">داشبورد</a></li>
                <li><a href="<?php echo e(route('admin.academy.academy.index')); ?>">لیست آموزشگاه ها</a></li>
                <li class="active">ایجاد آموزشگاه</li>
            </ol>
        </div>
    </div>

    <form method="post" action="<?php echo e(route('admin.academy.academy.store')); ?>" enctype="multipart/form-data">
        <?php echo e(csrf_field()); ?>

        <div class="row white z-depth-1">
            <div class="col-md-12">
                <span class="blue-grey darken-2 white-text title z-depth-2">ایجاد آموزشگاه</span>
                <?php echo $__env->make('share.extra.back2',['route'=>route('admin.academy.academy.index')], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>

            <div class="col-md-6 mb20">
                <label for="users">انتخاب کاربر</label>
                <multiselect id="users" v-model="user.selected" :options="user.list" @search-change="search($event,'user')" :custom-label="userLabel" :multiple="false" :close-on-select="true" track-by="id" :internal-search="false">
                        <span v-if="user.list.length > 0 && isMoreResult('user')"  @click="moreResult('user')" class="waves-effect waves-light btn quarter center-block teal darken-2 mt20" slot="afterList">
                            <span v-if="user.loading"><i class="fa fa-spinner fa-pulse fa-3x fa-fw"></i></span>
                            <span v-else>موارد بیشتر</span>
                        </span>
                </multiselect>
                <?php echo $__env->make('share.forms.error',['name'=>'user_id'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
            <div class="col-md-6 mb20">
                <label for="areas">انتخاب منطقه</label>
                <multiselect id="areas" v-model="area.selected" :options="area.list" @search-change="search($event,'area')" :custom-label="customLabel" :multiple="false" :close-on-select="true" track-by="id" :internal-search="false">
                        <span v-if="area.list.length > 0 && isMoreResult('area')"  @click="moreResult('area')" class="waves-effect waves-light btn quarter center-block teal darken-2 mt20" slot="afterList">
                            <span v-if="area.loading"><i class="fa fa-spinner fa-pulse fa-3x fa-fw"></i></span>
                            <span v-else>موارد بیشتر</span>
                        </span>
                </multiselect>
                <?php echo $__env->make('share.forms.error',['name'=>'area_id'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>

            <div class="clearfix"></div>
            <div class="col-md-12 mt15">
                <?php echo $__env->make('share.forms.input',['name'=>'title','title'=>'نام آموزشگاه'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
            <div class="clearfix"></div>
            <div class="col-md-4">
                <?php echo $__env->make('share.forms.input',['name'=>'telephone','title'=>'تلفن'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
            <div class="col-md-4">
                <?php echo $__env->make('share.forms.input',['name'=>'fax','title'=>'فکس'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
            <div class="col-md-4">
                <?php echo $__env->make('share.forms.input',['name'=>'postalCode','title'=>'کد پستی'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
            <div class="clearfix"></div>
            <div class="col-md-6">
                <?php echo $__env->make('share.forms.input',['name'=>'website','title'=>'وب سایت'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
            <div class="col-md-6">
                <?php echo $__env->make('share.forms.input',['name'=>'email','title'=>'ایمیل'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
            <div class="clearfix"></div>
            <div class="col-md-12">
                <?php echo $__env->make('share.forms.input',['name'=>'address','title'=>'آدرس'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
            <div class="clearfix"></div>
            <div class="col-md-6">
                <?php echo $__env->make('share.forms.input',['name'=>'telegram','title'=>'تلگرام'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
            <div class="col-md-6">
                <?php echo $__env->make('share.forms.input',['name'=>'whatsapp','title'=>'واتس آپ'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
            <div class="clearfix"></div>
            <div class="col-md-6">
                <?php echo $__env->make('share.forms.input',['name'=>'referalCode','title'=>'کد معرف'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
            <div class="clearfix"></div>
            <div class="col-md-6 mt40">
                <?php echo $__env->make('share.forms.switch',['name'=>'status','title'=>'فعال','checked'=>true], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
            <div class="col-md-6 mt40">
                <?php echo $__env->make('share.forms.switch',['name'=>'payStatus','title'=>'وضعیت پرداخت','checked'=>true], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
            <div class="clearfix"></div>


            <div class="col-md-4">
                <?php echo $__env->make('share.forms.file',['name'=>'cereficate','title'=>'مدرک'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
            <div class="col-md-4">
                <?php echo $__env->make('share.forms.file',['name'=>'logo','title'=>'لوگو'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
            <div class="col-md-4">
                <?php echo $__env->make('share.forms.file',['name'=>'picture','title'=>'عکس'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
            <div class="clearfix"></div>
            <hr class="mt40">
            <h5 class="pd4 br4 blue-grey darken-2 text-center white-text half center-block">مشخصات موسس</h5>
            <div class="col-md-6">
                <?php echo $__env->make('share.forms.input',['name'=>'firstNameOwner','title'=>'نام موسس'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
            <div class="col-md-6">
                <?php echo $__env->make('share.forms.input',['name'=>'lastNameOwner','title'=>'نام خانوادگی موسس'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
            <div class="clearfix"></div>
            <div class="col-md-6">
                <?php echo $__env->make('share.forms.input',['name'=>'birthdayOwner','title'=>'تاریخ تولد موسس','class' => 'birthday'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
            <div class="col-md-6">
                <?php echo $__env->make('share.forms.input',['name'=>'birthplaceOwner','title'=>'محل تولد موسس'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
            <div class="clearfix"></div>
            <div class="col-md-4">
                <?php echo $__env->make('share.forms.input',['name'=>'mobileOwner','title'=>'موبایل موسس','class' => 'dleft'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
            <div class="col-md-4">
                <?php echo $__env->make('share.forms.input',['name'=>'nationalCodeOwner','title'=>'کد ملی موسس','class' => 'dleft'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
            <div class="col-md-4">
                <?php echo $__env->make('share.forms.file',['name'=>'nationalCardOwner','title'=>'کارت ملی موسس'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
            <div class="clearfix"></div>
            <hr class="mt40">
            <h5 class="pd4 br4 blue-grey darken-2 text-center white-text half center-block">مشخصات مدیر آموزشگاه</h5>
            <div class="col-md-6">
                <?php echo $__env->make('share.forms.input',['name'=>'firstNameAdmin','title'=>'نام مدیر'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
            <div class="col-md-6">
                <?php echo $__env->make('share.forms.input',['name'=>'lastNameAdmin','title'=>'نام خانوادگی مدیر'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
            <div class="clearfix"></div>
            <div class="col-md-6">
                <?php echo $__env->make('share.forms.input',['name'=>'birthdayAdmin','title'=>'تاریخ تولد مدیر','class' => 'birthday'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
            <div class="col-md-6">
                <?php echo $__env->make('share.forms.input',['name'=>'birthplaceAdmin','title'=>'محل تولد مدیر'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
            <div class="clearfix"></div>
            <div class="col-md-4">
                <?php echo $__env->make('share.forms.input',['name'=>'mobileAdmin','title'=>'موبایل مدیر','class' => 'dleft'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
            <div class="col-md-4">
                <?php echo $__env->make('share.forms.input',['name'=>'nationalCodeAdmin','title'=>'کد ملی مدیر','class' => 'dleft'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
            <div class="col-md-4">
                <?php echo $__env->make('share.forms.file',['name'=>'nationalCardAdmin','title'=>'کارت ملی مدیر'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>



            <div>
                <input type="hidden" id="user_id" name="user_id">
                <input type="hidden" id="area_id" name="area_id">
            </div>

            <div class="col-md-12 mb20 mt20 ">
                <button class="waves-effect waves-light btn quarter center-block blue darken-1">ذخیره</button>
            </div>

        </div>

    </form>
<?php $__env->stopSection(); ?>


<?php $__env->startPush('scripts'); ?>
    <script src="<?php echo e(asset('assets/plugins/vueselect/vueselect.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/plugins/datePicker/persianDate.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/plugins/datePicker/datePicker.js')); ?>"></script>
    <script>
        $(document).ready(function () {
            $(".birthday").pDatepicker({
                format : "YYYY/MM/DD",
                maxDate: new persianDate().valueOf(),
                initialValueType: 'gregorian'
            });
        });

        Vue.component('Multiselect', VueMultiselect.default);
        new Vue({
            el:'#app',
            data:{
                ax:axios.create({baseURL: baseUrl,headers:{'Authorization':'Bearer <?php echo e(auth()->user()->api_token); ?>'}}),

                user:{
                    url:'/v1/admin/users/user',
                    list:[],
                    selected:[],
                    query:'',
                    params:{},
                    data:[],
                    loading:false
                },
                area:{
                    url:'/v1/region/area',
                    list:[],
                    selected:[],
                    query:'',
                    params:{},
                    data:[],
                    loading:false
                },
            },
            created: function () {
                this.search(null, 'user');
                this.search(null, 'area');
            },
            methods:{
                search: function (query, field, extraQuery = {}) {
                    this[field].params = extraQuery;
                    if (query) {
                        this[field].params.query = query;
                    }

                    if (query !== '' || query === null) {
                        this.ax.get(this[field].url, {params: this[field].params}).then(function (response) {
                            this[field].query = query;
                            this[field].list = response.data.data;
                            this[field].data = response.data;
                        }.bind(this));
                    }
                },
                userLabel: function (element) {
                    return element.id + ' - ' + element.firstName +' - ' + element.lastName;
                },


                customLabel: function (element) {
                    return element.id + ' - ' + element.title;
                },
                isMoreResult: function (field) {
                    return (this[field].data.current_page + 1 <= this[field].data.last_page);
                },
                moreResult: function (field) {
                    if (this.isMoreResult(field)) {
                        this[field].loading = true;
                        this[field].params.page = this[field].data.current_page + 1;

                        this.ax.get(this[field].url, {params: this[field].params}).then(function (response) {
                            this[field].list = this[field].list.concat(response.data.data);
                            this[field].data = response.data;
                            this[field].loading = false;
                        }.bind(this));
                    }
                }
            },
            watch: {
                'user.selected': function () {
                    if (this.user.selected.id) {
                        document.getElementById('user_id').value = this.user.selected.id;
                    } else {
                        document.getElementById('user_id').value = null;
                    }
                },
                'area.selected': function () {
                    if (this.area.selected.id) {
                        document.getElementById('area_id').value = this.area.selected.id;
                    } else {
                        document.getElementById('area_id').value = null;
                    }
                },
            }
        });
    </script>

<?php $__env->stopPush(); ?>

<?php $__env->startPush('styles'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('assets/plugins/vueselect/vueselect.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/plugins/datePicker/persianDatePicker.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/plugins/datePicker/custom.css')); ?>" />
    
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layout.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/vagrant/code/work/emi/resources/views/admin/Academy/academy/create.blade.php ENDPATH**/ ?>