<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-md-12 ">
            <ol class="breadcrumb">
                <li><a href="<?php echo e(route('user.home')); ?>">صفحه اصلی</a></li>
                <li class="active">لیست پیام ها</li>
            </ol>
        </div>
    </div>

    <div class="row">
        <modal v-if="modal.destroy" @close="modal.destroy=false">
            <h3 style="margin:0" slot="header">آیا مایل به حذف هستید؟</h3>
            <div slot="body" class="row">
                <div class="col-md-12">
                    <div class="col-md-4">
                        <div class="col-md-12 blue-grey white-text pd5 z-depth-2 br4 text-center">شناسه</div>
                    </div>
                    <div class="col-md-8">
                        <div class="col-md-12 blue-grey white-text pd5 z-depth-2 br4 text-center" v-text="model.id"></div>
                    </div>
                    <div class="clearfix mb10"></div>
                    <div class="col-md-4">
                        <div class="col-md-12 blue-grey white-text pd5 z-depth-2 br4 text-center">تیتر</div>
                    </div>
                    <div class="col-md-8">
                        <div class="col-md-12 blue-grey white-text pd5 z-depth-2 br4 text-center" v-text="model.title"></div>
                    </div>
                </div>
            </div>
            <div slot="footer">
                <a @click.prevent.default="Destroy" href="#!" class="waves-effect waves-green btn quarter right">Yes</a>
                <a @click.prevent.default="modal.destroy=false" href="#!" class="waves-effect waves-green btn quarter blue-grey darken-2">No</a>
            </div>
        </modal>
    </div>
    <div class="row white z-depth-1">
            <div class="col-md-4 col-md-offset-4 mt10 text-center">
                <a :href="currentUrl+'create'" class="waves-effect full waves-light btn blue-grey darken-2" ><i class="material-icons left">add</i>ایجاد پیام</a>
            </div>
        <div class="col-md-12">
            <div class="input-field">
                <input id="query" name="query" type="text" class="validate" v-model="query">
                <label for="query">جستجو</label>
            </div>
        </div>
        <div class="col-md-12 pd4">
            <div class="table-responsive">
                <table class="table table-bordered table-hover white">
                    <thead class="blue-grey darken-2 white-text">
                    <tr>
                        <th @click="sort('id')">شناسه
                            <i v-if="params.id === 'asc'" class="fa fa-sort-amount-asc" aria-hidden="true"></i>
                            <i v-if="params.id === 'desc'" class="fa fa-sort-amount-desc" aria-hidden="true"></i>
                        </th>
                        <th @click="sort('title')">تیتر
                            <i v-if="params.title === 'asc'" class="fa fa-sort-amount-asc" aria-hidden="true"></i>
                            <i v-if="params.title === 'desc'" class="fa fa-sort-amount-desc" aria-hidden="true"></i>
                        </th>
                        <th @click="sort('ticketManage_id')">دپارتمان
                            <i v-if="params.ticketManage_id === 'asc'" class="fa fa-sort-amount-asc" aria-hidden="true"></i>
                            <i v-if="params.ticketManage_id === 'desc'" class="fa fa-sort-amount-desc" aria-hidden="true"></i>
                        </th>
                        <th @click="sort('referer_count')">تعداد پیام ها
                            <i v-if="params.referer_count === 'asc'" class="fa fa-sort-amount-asc" aria-hidden="true"></i>
                            <i v-if="params.referer_count === 'desc'" class="fa fa-sort-amount-desc" aria-hidden="true"></i>
                        </th>
                        <th @click="sort('status')">وضعیت
                            <i v-if="params.status === 'asc'" class="fa fa-sort-amount-asc" aria-hidden="true"></i>
                            <i v-if="params.status === 'desc'" class="fa fa-sort-amount-desc" aria-hidden="true"></i>
                        </th>
                        <th>عملیات</th>
                    </tr>
                    </thead>
                    <tbody>
                    <tr v-for="item in itemList">
                        <td v-text="item.id"></td>
                        <td v-text="item.title"></td>
                        <td v-text="item.department.title"></td>
                        <td v-text="item.messages_count"></td>
                        <td v-text="translateStatus(item.status)"></td>
                        <td>
                            <a :href="'/panel/user/ticket/ticketmessages/messages/'+item.id" class="btn-floating waves-effect waves-light blue"><i class="material-icons">remove_red_eye</i></a>
                        </td>
                    </tr>
                    </tbody>
                </table>
            </div>
        </div>
        <div class="col-md-12">
            <paginate v-if="itemList" v-model="itemList" :is-reset="reset" :url="currentUrl" :params="params"></paginate>
        </div>
    </div>
    <vue-toastr ref="toastr"></vue-toastr>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script src="<?php echo e(asset('assets/js/paginator.js')); ?>"></script>

<script>
    new Vue({
        el:'#app',
        data:{
            currentUrl:location.pathname+'/',
            instance:axios.create({baseURL: location.pathname,}),
            itemList:[],
            reset:false,
            params:{},
            query:'',
            modal:{
                destroy:false
            },
            model:{
                mode:'create',
                id:'',
                title:'',
                body:'',
                destroy:[]
            }
        },
        methods:{
            translateStatus: function (status) {
                if (status == 'open') {
                    return 'باز';
                } else if(status == 'close') {
                    return 'بسته';
                } else if(status == 'pending') {
                    return 'در حال بررسی';
                } else {
                    return 'غیر فعال';
                }
            },
            sort:function (query) {
                this.reset = !this.reset;
                if (this.changeSort(this.params[query]) === '') {
                    delete this.params[query];
                }
                else{
                    this.params[query] = this.changeSort(this.params[query]);
                }
            },
            changeSort:function (value) {
                if (value === '' || value === undefined) {
                    return 'desc';
                }
                else if (value === 'desc') {
                    return 'asc'
                }
                else{
                    return ''
                }

            },

            callDestroy:function (item) {
                this.model.id    = item.id;
                this.model.title = item.title;

                this.modal.destroy  = true;
            },
            Destroy:function () {
                var id = this.model.id;
                this.instance.delete('/'+id,{}).then(function (response) {
                    this.reset = !this.reset;
                    this.modal.destroy = false;
                    this.$refs.toastr.defaultPosition = "toast-bottom-left";
                    this.$refs.toastr.s("حذف شد");
                }.bind(this));
            }
        },
        computed:{
            isEdit:function () {
                return (this.model.mode === 'edit');
            },
            isDestroy:function () {
                return (this.model.mode === 'destroy');
            },
        },
        watch:{
            query:function () {
                this.params.query = this.query;
                this.reset = !this.reset;
            }
        },
        components: {
            'vue-toastr': window.vueToastr,
        }
    });
</script>
<?php $__env->stopPush(); ?>
<?php $__env->startPush('styles'); ?>
<style>
    .fixed-action-btn {
        right: 25px;
    }
    .fixed-action-btn ul a{
        width: 140px;
        -webkit-border-radius: 4px;
        -moz-border-radius: 4px;
        border-radius: 4px;
        text-align: right;
    }
    .fixed-action-btn ul a i {
        display: inline;
        position: absolute;
        top: 0;
        left: 55px;
    }
    .fixed-action-btn ul a span {
        position: absolute;
        right: 28px;
        bottom: 2px;
    }
    .fixed {
        position: fixed;
        right: 25px;
        bottom: 23px;
        z-index: 998;
    }
</style>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('user.layout.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/afcclub/club/resources/views/user/Ticket/ticket/index.blade.php ENDPATH**/ ?>