<?php $__env->startSection('content'); ?>
<div class="row">

    <div class="row">
        <div class="col-md-12">
            <h4>کاربران</h4>
            <hr>
        </div>
        <div class="clearfix"></div>

        <div class="col-md-3">
            <div class="card-panel row home-panel">
                <div class="col-md-8">
                    <h2>تعداد کاربران</h2>
                    <p><?php echo e(number_format($users)); ?></p>
                </div>
                <div class="col-md-4 text-center">
                    <i class="fa fa-users sorange-bg" aria-hidden="true"></i>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card-panel row home-panel">
                <div class="col-md-8">
                    <h2>تعداد مدیران</h2>
                    <p><?php echo e(number_format($admins)); ?></p>
                </div>
                <div class="col-md-4 text-center">
                    <i class="fa fa-user-secret sorange-bg" aria-hidden="true"></i>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card-panel row home-panel">
                <div class="col-md-8">
                    <h2>کاربران جدید</h2>
                    <p><?php echo e(number_format($newUsers)); ?></p>
                </div>
                <div class="col-md-4 text-center">
                    <i class="fa fa-user-plus sorange-bg" aria-hidden="true"></i>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card-panel row home-panel">
                <div class="col-md-8">
                    <h2>مدیران جدید</h2>
                    <p><?php echo e(number_format($newAdmins)); ?></p>
                </div>
                <div class="col-md-4 text-center">
                    <i class="fa fa-user-plus sorange-bg" aria-hidden="true"></i>
                </div>
            </div>
        </div>
    </div>





















































    <div class="row mt20">
        <div class="col-md-12">
            <h4>تیکت ها</h4>
            <hr>
        </div>
        <div class="clearfix"></div>

        <div class="col-lg-3 col-md-6">
            <div class="card-panel row home-panel">
                <div class="col-md-8">
                    <h2>باز</h2>
                    <p><?php echo e(number_format($ticketOpen)); ?></p>
                </div>
                <div class="col-md-4 text-center">
                    <i class="fa fa-comments sorange-bg" aria-hidden="true"></i>
                </div>
            </div>
        </div>
        <div class="col-lg-3 col-md-6">
            <div class="card-panel row home-panel">
                <div class="col-md-8">
                    <h2>بسته</h2>
                    <p><?php echo e(number_format($ticketClose)); ?></p>
                </div>
                <div class="col-md-4 text-center">
                    <i class="fa fa-comments sorange-bg" aria-hidden="true"></i>
                </div>
            </div>
        </div>
        <div class="col-lg-3 col-md-6">
            <div class="card-panel row home-panel">
                <div class="col-md-8">
                    <h2>در حال پیگیری</h2>
                    <p><?php echo e(number_format($ticketPending)); ?></p>
                </div>
                <div class="col-md-4 text-center">
                    <i class="fa fa-comments sorange-bg" aria-hidden="true"></i>
                </div>
            </div>
        </div>
        <div class="col-lg-3 col-md-6">
            <div class="card-panel row home-panel">
                <div class="col-md-8">
                    <h2>غیر فعال</h2>
                    <p><?php echo e(number_format($ticketDeactive)); ?></p>
                </div>
                <div class="col-md-4 text-center">
                    <i class="fa fa-comments sorange-bg" aria-hidden="true"></i>
                </div>
            </div>
        </div>
    </div>

    <div class="row mt20">
        <div class="col-md-6">
            <div class="boxshadow-1 pd10">
                <canvas id="userChart" width="400" height="200"></canvas>
            </div>
        </div>
        <div class="col-md-6">
            <div class="card-panel">
                <canvas id="userServiceCardChart"></canvas>
            </div>
        </div>
    </div>


</div>
<?php $__env->stopSection(); ?>


<?php $__env->startPush('scripts'); ?>
    <script src="<?php echo e(asset('assets/js/chartjs.js')); ?>"></script>
    <script>

        var ctx = document.getElementById("userChart").getContext('2d');
        var myChart = new Chart(ctx, {
            type: 'bar',
            data: {
                labels: <?php echo $userChart->pluck('day'); ?>,
                datasets: [{
                    label: "ثبت نام کاربران <?php echo e(toPersian(today(),'Y')); ?> ",
                    data:<?php echo $userChart->pluck('user_count'); ?>,
                    backgroundColor: '#03a9f4',
                    borderColor:'#03a9f4',
                    borderWidth: 1
                }]
            },
            options: {
                scales: {
                    yAxes: [{
                        ticks: {
                            beginAtZero:true
                        }
                    }]
                }
            }
        });


        var ctx2 = document.getElementById("userServiceCardChart").getContext('2d');
        var myChart = new Chart(ctx2, {
            type: 'bar',
            data: {
                labels: <?php echo $userServiceCardChart->pluck('day'); ?>,
                datasets: [{
                    label: 'کارت های خریداری شده',
                    data:<?php echo $userServiceCardChart->pluck('user_count'); ?>,
                    backgroundColor: '#03a9f4',
                    borderColor:'#03a9f4',
                    borderWidth: 1
                }]
            },
            options: {
                scales: {
                    yAxes: [{
                        ticks: {
                            beginAtZero:true
                        }
                    }]
                }
            }
        });

    </script>

<?php $__env->stopPush(); ?>


<?php $__env->startPush('styles'); ?>

    <style>
        .panel-title::before {
            content: "";
            position: absolute;
            right: 0;
            left: -40px;
            bottom: 0;
            background-color: #ef5661;
            height: 1px;
            z-index: 1;
        }

        .boxshadow-1 {
            box-shadow: 0 0 2rem 0 rgba(136,152,170,.15) !important;
        }
    </style>

<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layout.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/vhosts/work.sheypoorchy.ir/golaren/resources/views/admin/panel.blade.php ENDPATH**/ ?>