<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-md-12 ">
            <ol class="breadcrumb">
                <li><a href="<?php echo e(route('admin.home')); ?>">صفحه اصلی</a></li>
                <li><a href="<?php echo e(route('admin.tickets.index')); ?>">لیست پیام ها</a></li>
                <li class="active">نمایش پیام</li>
            </ol>
        </div>
    </div>

    <div class="row white z-depth-1">
        <div class="clearfix"></div>
        <div class="col-md-12">
            <h2 class="text-center"><?php echo e($ticket->title); ?></h2>
            <p><?php echo e($ticket->body); ?></p>
            <?php if($ticket->pathFile): ?>
                <a class="waves-effect waves-light btn mt10" href="<?php echo e(asset($ticket->pathFile)); ?>" download><i class="material-icons right">attach_file</i>دانلود فایل</a>
            <?php endif; ?>
            <hr>
        </div>
        <div class="col-md-6">
            <p class=" text-center pd5 blue-grey darken-2 white-text br4 z-depth-1 mb10 mr10 quarter"><?php echo e($ticket->user->firstName.' '.$ticket->user->lastName); ?></p>
        </div>
        <div class="col-md-6 text-left">
            <p class="text-center pd5 blue-grey darken-2 white-text br4 z-depth-1 mb10 mr10 half dleft right"><?php echo e(toPersian($ticket->created_at)); ?></p>
        </div>
    </div>

    <?php $__currentLoopData = $messages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $message): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="row white z-depth-1 mt20">
            <div class="col-md-12 mt5">
                <?php if($message->user_id == auth()->user()->id): ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('ticketMessage_update')): ?>
                        <a href="<?php echo e(route('admin.ticketmessages.indexMessage',[$message->ticket_id,'message_id'=>$message->id])); ?>" class="btn-floating waves-effect waves-light blue"><i class="material-icons">edit</i></a>
                    <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('ticketMessage_destroy')): ?>
                            <form style="display: inline" method="post" action="<?php echo e(route('admin.ticketmessages.destroy',$message->id)); ?>">
                                <?php echo e(csrf_field()); ?>

                                <?php echo e(method_field('DELETE')); ?>

                                <button type="submit" href="<?php echo e(route('admin.ticketmessages.destroy',$message->id)); ?>" class="btn-floating waves-effect waves-light red"><i class="material-icons">delete</i></button>
                            </form>
                    <?php endif; ?>
                <?php endif; ?>
            </div>
            <div class="col-md-12">
                <h2 class="text-center"><?php echo e($message->title); ?></h2>
                <p><?php echo e($message->body); ?></p>
                <?php $__currentLoopData = $message->files; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $file): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <a class="waves-effect waves-light btn mt10" href="<?php echo e(asset($file->path)); ?>" download><i class="material-icons right">attach_file</i>دانلود فایل</a>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <hr>
            </div>
            <div class="col-md-4">
                <p class="text-center pd5 blue-grey darken-1 white-text br4 z-depth-1 mb10 col-md-6"><?php echo e($message->user->firstName.' '.$message->user->lastName); ?></p>
            </div>
            <div class="col-md-4">
                <p class="text-center pd5 blue-grey darken-1 white-text br4 z-depth-1 mb10 col-md-6 col-md-offset-3">وضعیت نمایش : <?php echo e(($message->type == 'all')?'همه':'مدیران'); ?></p>
            </div>
            <div class="col-md-4 text-left">
                <p class="text-center pd5 blue-grey darken-2 white-text br4 z-depth-1 mb10 mr10 half dleft right"><?php echo e(toPersian($message->created_at)); ?></p>
            </div>
        </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

    <div class="row white z-depth-1 mt40">
        <?php if(request()->has('message_id')): ?>
            <form method="post" action="<?php echo e(route('admin.ticketmessages.update',$ticketMessage->id)); ?>" enctype="multipart/form-data">
                <?php echo e(method_field('PUT')); ?>

                <?php echo e(csrf_field()); ?>

                <div class="col-md-12">
                    <span class="blue-grey darken-2 white-text title z-depth-2">ویرایش پاسخ</span>
                </div>
                <div class="col-md-12">
                    <?php echo $__env->make('share.forms.textarea-Material',['name'=>'body','title'=>'Text','value'=>$ticketMessage->body], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>
                <div class="col-md-6">
                    <?php echo $__env->make('share.forms.select',['name'=>'type','title'=>'وضعیت نمایش','options'=>['all'=>'همه','note'=>'مدیران'],'selected'=>$ticketMessage->type], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>
                <div class="col-md-6">
                    <?php echo $__env->make('share.forms.file',['name'=>'files[]','title'=>'آپلود فایل','multiple'=>true], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>


                <div class="col-md-12 mb20 mt20">
                    <button class="waves-effect waves-light btn quarter center-block blue-grey darken-2">ذخیره</button>
                </div>
                <div>
                    <input type="hidden" name="ticket_id" value="<?php echo e($ticket->id); ?>">
                </div>

            </form>
        <?php else: ?>
            <form method="post" action="<?php echo e(route('admin.ticketmessages.store')); ?>" enctype="multipart/form-data">
                <?php echo e(csrf_field()); ?>

                <div class="col-md-12">
                    <span class="blue-grey darken-2 white-text title z-depth-2">ایجاد پاسخ</span>
                </div>
                <div class="col-md-12">
                    <?php echo $__env->make('share.forms.textarea-Material',['name'=>'body','title'=>'Text'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>
                <div class="col-md-6">
                    <?php echo $__env->make('share.forms.select',['name'=>'type','title'=>'وضعیت نمایش','options'=>['all'=>'همه','note'=>'مدیران'],'selected'=>'all'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>
                <div class="col-md-6">
                    <?php echo $__env->make('share.forms.file',['name'=>'files[]','title'=>'آپلود فایل','multiple'=>true], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>


                <div class="col-md-12 mb20 mt20">
                    <button class="waves-effect waves-light btn quarter center-block blue-grey darken-2">ذخیره</button>
                </div>
                <div>
                    <input type="hidden" name="ticket_id" value="<?php echo e($ticket->id); ?>">
                </div>

            </form>
        <?php endif; ?>
    </div>

    <?php echo $__env->make('share.extra.back',['route'=>route('admin.ticketmessages.index')], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>

    <script>
        $(document).ready(function () {
            $('select').material_select();
        });
    </script>

<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layout.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/afcclub/club/resources/views/admin/Ticket/message/indexMessages.blade.php ENDPATH**/ ?>