<?php $__env->startSection('content'); ?>

    <div class="homepage">

        <div class="container section1-banner mt40">
            <div class="row">
                <div class="col-md-8">
                    <img class="main-banner" src="<?php echo e(asset('assets/img/slideshow/03.jpg')); ?>" alt="">
                </div>
                <div class="col-md-4">
                    <div class="col-md-12 mb15">
                        <img class="left-banner" src="<?php echo e(asset('assets/img/slideshow/01.jpg')); ?>" alt="">
                    </div>
                    <div class="col-md-12 mb15">
                        <img class="left-banner" src="<?php echo e(asset('assets/img/slideshow/01.jpg')); ?>" alt="">
                    </div>
                    <div class="col-md-12">
                        <img class="left-banner" src="<?php echo e(asset('assets/img/slideshow/01.jpg')); ?>" alt="">
                    </div>
                </div>
            </div>
        </div>

        <div id="vue_app" class="container-fluid">

            <div class="row mt20 section-line">
                <div class="col-md-12">

                    <div class="col-md-3 col-xs-12 pd0">
                        <div class="col-md-4 col-xs-4 text-left">
                            <img style="height: 50px" src="<?php echo e(asset('assets/img/homepage/line/icon-1.svg')); ?>" alt="">
                        </div>
                        <div class="col-md-8 col-xs-8">
                            <p class="text-right mt15">دسترسی آسان</p>
                        </div>
                    </div>
                    <div class="col-md-3 col-xs-12 pd0">
                        <div class="col-md-4 col-xs-4 text-left">
                            <img src="<?php echo e(asset('assets/img/homepage/line/icon-2.svg')); ?>" alt="">
                        </div>
                        <div class="col-md-8 col-xs-8">
                            <p class="text-right mt20">صرفه جویی در زمان</p>
                        </div>
                    </div>
                    <div class="col-md-3 col-xs-12 pd0">
                        <div class="col-md-4 col-xs-4 text-left">
                            <img src="<?php echo e(asset('assets/img/homepage/line/icon-3.svg')); ?>" alt="">
                        </div>
                        <div class="col-md-8 col-xs-8">
                            <p class="text-right mt20">قیمت مناسب</p>
                        </div>
                    </div>
                    <div class="col-md-3 col-xs-12 pd0">
                        <div class="col-md-4 col-xs-4 text-left">
                            <img src="<?php echo e(asset('assets/img/homepage/line/icon-4.svg')); ?>" alt="">
                        </div>
                        <div class="col-md-8 col-xs-8 pd0">
                            <p class="text-right mt15 user-comment">
                                <span class="blue-text">علی صبوری</span>
                                <span>(طراح گرافیست)</span>
                                <br>
                                <span>خوشحال میشم بتوانم تجربه کاری خوبی ...</span>
                            </p>
                        </div>
                    </div>

                </div>
            </div>

            <div class="row section-map">
                <div class="col-md-12 col-sm-12 col-xs-12">
                    <div class="x_panel">
                        <div class="col-md-12">
                            <h2 class="text-center pd20 section-title">جستجوی دانشجویان</h2>
                        </div>
                        <div class="x_content">

                            <div class="col-md-3 text-center mt40">
                                <div class="col-md-12">
                                    <label for="states_vue">انتخاب استان محل سکونت</label>
                                    <multiselect id="states_vue" v-model="state.selected" :options="state.list" @search-change="search($event,'state')" :custom-label="customLabel" :multiple="false" :close-on-select="true" track-by="id" :internal-search="false">
                                        <span v-if="state.list.length > 0 && isMoreResult('state')"  @click="moreResult('state')" class="waves-effect waves-light btn half center-block teal darken-2 mt20" slot="afterList">
                                            <span v-if="state.loading"><i class="fa fa-spinner fa-pulse fa-3x fa-fw"></i></span>
                                            <span v-else>موارد بیشتر</span>
                                        </span>
                                    </multiselect>
                                </div>
                                <div class="col-md-12 mt20">
                                    <label for="cities_vue">انتخاب شهر محل سکونت</label>
                                    <multiselect id="cities_vue" v-model="city.selected" :options="city.list" @search-change="search($event,'city',{withstate:1,state:state.selected.id})" :custom-label="cityLabel" :multiple="false" :close-on-select="true" track-by="id" :internal-search="false">
                                <span v-if="city.list.length > 0 && isMoreResult('city')"  @click="moreResult('city')" class="waves-effect waves-light btn half center-block teal darken-2 mt20" slot="afterList">
                                    <span v-if="city.loading"><i class="fa fa-spinner fa-pulse fa-3x fa-fw"></i></span>
                                    <span v-else>موارد بیشتر</span>
                                </span>
                                    </multiselect>
                                    <?php echo $__env->make('share.forms.error',['name'=>'city_id'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </div>
                                <div class="col-md-12 mt20">
                                    <label for="skills">انتخاب مهارت / تخصص</label>
                                    <multiselect id="skills" v-model="skill.selected" :options="skill.list" @search-change="search($event,'skill')" :custom-label="customLabel" :multiple="false" :close-on-select="true" track-by="id" :internal-search="false">
                                    <span v-if="skill.list.length > 0 && isMoreResult('skill')"  @click="moreResult('skill')" class="waves-effect waves-light btn half center-block teal darken-2 mt20" slot="afterList">
                                        <span v-if="skill.loading"><i class="fa fa-spinner fa-pulse fa-3x fa-fw"></i></span>
                                        <span v-else>موارد بیشتر</span>
                                    </span>
                                    </multiselect>
                                    <?php echo $__env->make('share.forms.error',['name'=>'skill_id'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </div>
                                <div class="col-md-12 mt20">
                                    <button class="waves-effect waves-light btn  center-block green full-width" @click="searchBtn()">استعلام</button>
                                </div>


                            </div>

                            <div class="col-md-9 text-right">
                                <div class="center-block" id="map"></div>
                            </div>

                        </div>
                    </div>
                </div>
            </div>

            <div class="row mt20 mb20">
                <div class="col-md-12 type">
                    <h2 class="text-center">
                        آیا به دنبال
                        <span class="orange-text" id="typed"></span>
                        هستید؟
                    </h2>
                    <h2 class="text-center mt40">با ما همراه باشید</h2>
                </div>
            </div>

            <div class="row section-video pd10">
                <div class="col-md-12 mt20 mb20">
                    <h2 class="text-center white-text section-video-title pd10">معرفی شبکه دانشگاه های مجازی جهان اسلام</h2>
                </div>
                <div class="col-md-12 text-center">
                    <video
                        id="my-video"
                        class="video-js text-center center-block"
                        controls
                        preload="auto"
                        width="800"
                        height="500"
                        responsive="true"
                        data-setup="{}"
                    >
                        <source src="<?php echo e(asset('assets/files/jahan.mp4')); ?>" type="video/mp4"/>
                        <p class="vjs-no-js">
                            لطفا مرورگر خود را فعال نمایید
                        </p>
                </div>
            </div>

        </div>

        <div class="container-fluid">
            <?php $__currentLoopData = $serviceDepartments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $serviceDepartment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="row section3 scrollspy" id="service_<?php echo e($serviceDepartment->id); ?>">

                    <div class="col-md-12">
                        <div class="section3-body ">

                            <div class="categories col-md-12">
                                <div class="col-md-12">
                                    <h4 class="section3-title">
                                        <span>
                                            <?php echo e($serviceDepartment->title); ?>

                                        </span>
                                    </h4>
                                </div>

                                <div class="categories2 col-md-12">
                                    <?php $__currentLoopData = $serviceDepartment->category; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="col-md-12">
                                            <div class="card small">
                                                <div class="card-image waves-effect waves-block waves-light">
                                                    <img class="img-responsive" src="<?php echo e($category->pictureApi); ?>">
                                                </div>
                                                <div class="card-content text-center">
                                                    <span class="card-title activator grey-text text-darken-4 text-center"><?php echo e($category->title); ?></span>
                                                </div>

                                                <div class="card-action text-center">
                                                    <?php if($category->body): ?>
                                                        <a class="waves-effect waves-light custom-btn" href="<?php echo e(route('front.serviceCategory.show',$category->id)); ?>">بیشتر بدانید</a>
                                                    <?php else: ?>
                                                        <?php if($serviceDepartment->id == 7): ?>
                                                            <a class="waves-effect waves-light custom-btn" href="#modal_<?php echo e($loop->index.$serviceDepartment->id); ?>">بیشتر بدانید</a>
                                                        <?php else: ?>
                                                            <a class="waves-effect waves-light custom-btn" href="<?php echo e(url('/panel/admin/home')); ?>">بیشتر بدانید</a>
                                                        <?php endif; ?>
                                                    <?php endif; ?>
                                                </div>

                                            </div>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            <?php $__currentLoopData = $serviceDepartments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $department): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php $__currentLoopData = $department->category; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                    <div id="modal_<?php echo e($loop->index.$serviceDepartment->id); ?>" class="modal">
                        <div class="modal-content">

                            <?php $__currentLoopData = $category->offer; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $offer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="col-md-3">
                                    <div class="card medium">
                                        <div class="card-image waves-effect waves-block waves-light">
                                            <img class="img-responsive" src="<?php echo e(asset($offer->pictureApi)); ?>">
                                        </div>
                                        <div class="card-content text-center text-center">
                                            <span class="card-title activator grey-text text-darken-4 text-center"><?php echo e($offer->title); ?></span>
                                        </div>
                                        <div class="card-action text-center">
                                            <a class="waves-effect waves-light custom-btn" target="_blank" href="<?php echo e(route('front.serviceOffer.click',$offer->id)); ?>">ورود به سایت</a>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        </div>
                    </div>

                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            <div class="row mt40 mb40">
                <div class="section4">

                    <h4 class="section4-title">همکاران راهبردی</h4>
                    <hr class="mb40">

                </div>
            </div>
        </div>

        <div class="container-fluid section-partner">

            <div class="col-md-2 pd0"></div>
            <div class="col-md-1 pd5">
                <div class=" waves-effect waves-block waves-light">
                    <a target="_blank" href="https://team-grp.ir/">
                        <img class="img-responsive" src="<?php echo e(asset('assets/img/companies/5.png')); ?>">
                    </a>
                </div>
            </div>
            <div class="col-md-1 pd5">
                <div class=" waves-effect waves-block waves-light">
                    <a href="#">
                        <img class="img-responsive" src="<?php echo e(asset('assets/img/companies/4.png')); ?>">
                    </a>
                </div>
            </div>
            <div class="col-md-1 pd5">
                <div class=" waves-effect waves-block waves-light">
                    <a href="#">
                        <img class="img-responsive" src="<?php echo e(asset('assets/img/companies/new/1.jpeg')); ?>">
                    </a>
                </div>
            </div>
            <div class="col-md-1 pd5">
                <div class=" waves-effect waves-block waves-light">
                    <a href="#">
                        <img class="img-responsive" src="<?php echo e(asset('assets/img/companies/new/2.jpeg')); ?>">
                    </a>
                </div>
            </div>
            <div class="col-md-1 pd5">
                <div class=" waves-effect waves-block waves-light">
                    <a href="#">
                        <img class="img-responsive" src="<?php echo e(asset('assets/img/companies/new/3.jpeg')); ?>">
                    </a>
                </div>
            </div>
            <div class="col-md-1 pd5">
                <div class=" waves-effect waves-block waves-light">
                    <a href="#">
                        <img style="width: 80px !important;" class="img-responsive center-block" src="<?php echo e(asset('assets/img/companies/new/4.jpeg')); ?>">
                    </a>
                </div>
            </div>
            <div class="col-md-1 pd5">
                <div class=" waves-effect waves-block waves-light">
                    <a href="#">
                        <img class="img-responsive" src="<?php echo e(asset('assets/img/companies/new/5.jpeg')); ?>">
                    </a>
                </div>
            </div>
            <div class="clearfix mb20"></div>
            <div class="col-md-2 pd0"></div>
            <div class="col-md-1 pd5">
                <div class=" waves-effect waves-block waves-light">
                    <a href="#">
                        <img class="img-responsive" src="<?php echo e(asset('assets/img/companies/6.png')); ?>">
                    </a>
                </div>
            </div>
            <div class="col-md-1 pd5">
                <div class=" waves-effect waves-block waves-light">
                    <a href="#">
                        <img class="img-responsive text-center center-block" style="width: 110px !important;" src="<?php echo e(asset('assets/img/companies/new/7.jpeg')); ?>">
                    </a>
                </div>
            </div>
            <div class="col-md-1 pd5">
                <div class=" waves-effect waves-block waves-light">
                    <a href="#">
                        <img class="img-responsive" src="<?php echo e(asset('assets/img/companies/new/8.jpeg')); ?>">
                    </a>
                </div>
            </div>
            <div class="col-md-1 pd5">
                <div class=" waves-effect waves-block waves-light">
                    <a href="#">
                        <img class="img-responsive" src="<?php echo e(asset('assets/img/companies/new/9.jpeg')); ?>">
                    </a>
                </div>
            </div>
            <div class="col-md-1 pd5">
                <div class=" waves-effect waves-block waves-light">
                    <a href="#">
                        <img class="img-responsive" src="<?php echo e(asset('assets/img/companies/new/10.jpeg')); ?>">
                    </a>
                </div>
            </div>
            <div class="col-md-1 pd5">
                <div class=" waves-effect waves-block waves-light">
                    <a href="#">
                        <img style="width: 100px !important;" class="img-responsive center-block" src="<?php echo e(asset('assets/img/companies/new/11.jpeg')); ?>">
                    </a>
                </div>
            </div>
            <div class="col-md-1 pd5">
                <div class=" waves-effect waves-block waves-light">
                    <a href="#">
                        <img class="img-responsive" src="<?php echo e(asset('assets/img/companies/new/12.jpeg')); ?>">
                    </a>
                </div>
            </div>
            <div class="clearfix mb20"></div>
            <div class="col-md-2 pd0"></div>
            <div class="col-md-1 pd5">
                <div class=" waves-effect waves-block waves-light">
                    <a href="#">
                        <img style="width: 100px !important;" class="img-responsive center-block" src="<?php echo e(asset('assets/img/companies/new/13.jpeg')); ?>">
                    </a>
                </div>
            </div>
            <div class="col-md-1 pd5">
                <div class=" waves-effect waves-block waves-light">
                    <a href="#">
                        <img class="img-responsive" src="<?php echo e(asset('assets/img/companies/new/14.jpeg')); ?>">
                    </a>
                </div>
            </div>
            <div class="col-md-1 pd5">
                <div class=" waves-effect waves-block waves-light">
                    <a href="#">
                        <img style="width: 100px !important;" class="img-responsive center-block" src="<?php echo e(asset('assets/img/companies/new/15.jpeg')); ?>">
                    </a>
                </div>
            </div>


        </div>

    </div>

<?php $__env->stopSection(); ?>


<?php $__env->startPush('scripts'); ?>
    <script src="<?php echo e(asset('assets/js/typed.min.js')); ?>"></script>

    <link rel="stylesheet" href="<?php echo e(asset('assets/plugins/videojs/video.css')); ?>">
    <script src="<?php echo e(asset('assets/plugins/videojs/video.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/plugins/simplemap/mapdata.js')); ?>"></script>


    <script>
        $(document).ready(function () {
            $('.modal').modal();

            new Typed("#typed", {
                strings: [
                    ' معرفی خود و توانمندی هایتان',
                    ' مهارت آموزی و دریافت مدرک فنی و حرفه ای',
                    'ادامه تحصیل و دریافت مدرک دانشگاهی',
                    'آموزش تکمیلی و دریافت مدرک معتبر',
                    'دریافت خدمات خوب و ارزان',
                    'پوشش بیمه خوب و مقرون به صرفه',
                    'خرید خوب و ارزان',
                ],
                typeSpeed: 100,
                stringsElement: '#typed-strings',
                backSpeed: 40,
                backDelay: 2000,
                startDelay: 100,
                loop: true,
            });
        });


        Vue.component('Multiselect', VueMultiselect.default);
        new Vue({
            el: '#vue_app',
            data: {
                ax:axios.create({baseURL: baseUrl}),
                state:{
                    url:'/v1/region/state',
                    list:[],
                    selected:[],
                    query:'',
                    params:{},
                    data:[],
                    loading:false
                },

                city:{
                    url:'/v1/region/city',
                    list:[],
                    selected:[],
                    query:'',
                    params:{},
                    data:[],
                    loading:false
                },
                skill:{
                    url:'front/v1/skill/skill',
                    list:[],
                    selected:[],
                    query:'',
                    params:{},
                    data:[],
                    loading:false
                },

            },
            created:function () {
                this.search(null, 'state', {});
                this.search(null, 'skill', {orderby_id: "asc"});
            },
            methods: {
                cityLabel: function (element) {
                    return element.title;
                },
                searchBtn: function () {
                    if (this.city.selected.id && this.skill.selected.id) {
                        window.location.href = "skill?city_id="+this.city.selected.id +'&skill_id='+this.skill.selected.id;

                    } else {
                        if (!this.city.selected.id) {
                            swal({
                                title: 'لطفا شهر را انتخاب کنید',
                                text: 'لطفا شهر را انتخاب کنید',
                                type: "warning",
                                showConfirmButton: true,
                            });
                        } else if(!this.skill.selected.id){
                            swal({
                                title: 'لطفا مهارت را انتخاب کنید',
                                text: 'لطفا مهارت را انتخاب کنید',
                                type: "warning",
                                showConfirmButton: true,
                            });
                        }

                    }
                },

                search: function (query,field,extraQuery = {}) {
                    this[field].params = extraQuery;
                    if (query) {
                        this[field].params.query = query;
                    }

                    if (query !== '' || query === null) {
                        this.ax.get(this[field].url, {params:this[field].params}).then(function (response) {
                            this[field].query = query;
                            this[field].list = response.data.data;
                            this[field].data = response.data;
                        }.bind(this));
                    }
                },
                customLabel: function (element) {
                    return element.id+' - '+element.title;
                },
                isMoreResult:function (field) {
                    return (this[field].data.current_page+1 <= this[field].data.last_page);
                },
                moreResult:function (field) {
                    if (this.isMoreResult(field)) {
                        this[field].loading = true;
                        this[field].params.page = this[field].data.current_page + 1;

                        this.ax.get(this[field].url, {params:this[field].params}).then(function (response) {
                            this[field].list = this[field].list.concat(response.data.data);
                            this[field].data = response.data;
                            this[field].loading = false;
                        }.bind(this));
                    }
                }
            },
            watch: {
                'state.selected': function () {
                    if (this.state.selected) {
                        this.search(null, 'city', {withstate: 1,state_id:this.state.selected.id});
                    } else {
                        this.city.list = [];
                        this.city.selected = [];
                        document.getElementById('city_id').value = null;
                    }
                },
            }
        });
    </script>

    <script>
        $(document).ready(function () {
            $('form').attr('autocomplete', 'off');

            $('.slideshow').slick({
                rtl: true,
                infinite: true,
                autoplay: false,
                autoplaySpeed: 2000,
                arrows: true,
                swipeToSlide: true,
                slidesToShow: 1,
                slidesToScroll: 1,
                responsive: [
                    {
                        breakpoint: 1440,
                        settings: {
                            slidesToShow: 1
                        }
                    },
                    {
                        breakpoint: 992,
                        settings: {
                            centerMode: false,
                            slidesToShow: 1
                        }
                    },
                    {
                        breakpoint: 768,
                        settings: {
                            centerMode: false,
                            slidesToShow: 1
                        }
                    }
                ]
            });

            $('.categories2').slick({
                rtl: true,
                infinite: true,
                autoplay: true,
                autoplaySpeed: 2000,
                arrows: true,
                swipeToSlide: true,
                slidesToShow: 6,
                slidesToScroll: 1,
                responsive: [
                    {
                        breakpoint: 1440,
                        settings: {
                            slidesToShow: 4
                        }
                    },
                    {
                        breakpoint: 1280,
                        settings: {
                            slidesToShow: 3
                        }
                    },
                    {
                        breakpoint: 992,
                        settings: {
                            centerMode: false,
                            slidesToShow: 2
                        }
                    },
                    {
                        breakpoint: 768,
                        settings: {
                            centerMode: false,
                            slidesToShow: 1
                        }
                    }
                ]
            });

            $('.companeis').slick({
                rtl: true,
                infinite: true,
                autoplay: true,
                autoplaySpeed: 2000,
                arrows: true,
                swipeToSlide: true,
                slidesToShow: 5,
                slidesToScroll: 1,
                responsive: [
                    {
                        breakpoint: 1440,
                        settings: {
                            slidesToShow: 1
                        }
                    },
                    {
                        breakpoint: 992,
                        settings: {
                            centerMode: false,
                            slidesToShow: 1
                        }
                    },
                    {
                        breakpoint: 768,
                        settings: {
                            centerMode: false,
                            slidesToShow: 1
                        }
                    }
                ]
            });

            $(".scrollspy-custom li a[href^='#']").on('click', function (e) {

                e.preventDefault();
                $('html, body').animate({
                    scrollTop: $(this.hash).offset().top - 100
                }, 300, function () {
                    window.location.hash = this.hash;
                });

            });

        });
    </script>

    <script>
        var simplemaps_countrymap_mapdata={
            main_settings: {
                //General settings
                width: "700", //'700' or 'responsive'
                background_color: "#FFFFFF",
                background_transparent: "yes",
                border_color: "#ffffff",

                //State defaults
                state_description: "",
                state_color: "#88A4BC",
                state_hover_color: "#3B729F",
                state_url: "",
                border_size: 1.5,
                all_states_inactive: "no",
                all_states_zoomable: "yes",

                //Location defaults
                location_description: "Location description",
                location_url: "",
                location_color: "#FF0067",
                location_opacity: 0.8,
                location_hover_opacity: 1,
                location_size: 25,
                location_type: "square",
                location_image_source: "frog.png",
                location_border_color: "#FFFFFF",
                location_border: 2,
                location_hover_border: 2.5,
                all_locations_inactive: "no",
                all_locations_hidden: "no",

                //Label defaults
                label_color: "#d5ddec",
                label_hover_color: "#d5ddec",
                label_size: 22,
                label_font: "Arial",
                hide_labels: "no",
                hide_eastern_labels: "no",

                //Zoom settings
                zoom: "no",
                manual_zoom: "no",
                back_image: "no",
                initial_back: "no",
                initial_zoom: "-1",
                initial_zoom_solo: "no",
                region_opacity: 1,
                region_hover_opacity: 0.6,
                zoom_out_incrementally: "no",
                zoom_percentage: 0.99,
                zoom_time: 0.5,

                //Popup settings
                popup_color: "white",
                popup_opacity: 0.9,
                popup_shadow: 1,
                popup_corners: 5,
                popup_font: "12px/1.5 Verdana, Arial, Helvetica, sans-serif",
                popup_nocss: "no",

                //Advanced settings
                div: "map",
                auto_load: "yes",
                url_new_tab: "no",
                images_directory: "default",
                fade_time: 0.1,
                link_text: "View Website",
                popups: "detect",
                state_image_url: "",
                state_image_position: "",
                location_image_url: ""
            },
            state_specific: <?php echo json_encode($statesService2, 15, 512) ?>,
            labels: {},
            regions: {},
            data: {
                data: {
                    IRN3211: "100",
                }
            }
        };
    </script>

    <script src="<?php echo e(asset('assets/plugins/simplemap/countrymap.js')); ?>"></script>

<?php $__env->stopPush(); ?>

<?php echo $__env->make('front.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/vagrant/code/emi/resources/views/front/home/index.blade.php ENDPATH**/ ?>