<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-md-12 ">
            <ol class="breadcrumb">
                <li><a href="<?php echo e(route('admin.home')); ?>">صفحه اصلی</a></li>
                <li><a href="<?php echo e(route('admin.users.index')); ?>">لیست کاربران</a></li>
                <li class="active">تغییر وضعیت</li>
            </ol>
        </div>
    </div>

    <div class="row white z-depth-1">
        <div class="col-md-12 por">
            <span class="blue-grey darken-2 white-text title z-depth-2">تغییر وضعیت کاربر</span>
            <a href="<?php echo e(route('admin.users.index')); ?>" class="waves-effect waves-light btn blue darken-1 back-button"><i class="material-icons right">arrow_forward</i>بازگشت</a>
        </div>

        <div class="col-md-3">
            <h4 class="blue darken-3 white-text br4 pd4 z-depth-1 text-center">شناسه</h4>
            <p class="mt10 grey lighten-5 br4 pd4 z-depth-1 text-center"><?php echo e($user->id); ?></p>
        </div>
        <div class="col-md-3">
            <h4 class="blue darken-3 white-text br4 pd4 z-depth-1 text-center">نام کاربری</h4>
            <p class="mt10 grey lighten-5 br4 pd4 z-depth-1 text-center"><?php echo e($user->userName); ?></p>
        </div>
        <div class="col-md-3">
            <h4 class="blue darken-3 white-text br4 pd4 z-depth-1 text-center">نام</h4>
            <p class="mt10 grey lighten-5 br4 pd4 z-depth-1 text-center"><?php echo e($user->firstName); ?></p>
        </div>
        <div class="col-md-3">
            <h4 class="blue darken-3 white-text br4 pd4 z-depth-1 text-center">نام خانوادگی</h4>
            <p class="mt10 grey lighten-5 br4 pd4 z-depth-1 text-center"><?php echo e($user->lastName); ?></p>
        </div>
        <div class="clearfix mb20"></div>


        <div class="col-md-3">
            <h4 class="blue darken-3 white-text br4 pd4 z-depth-1 text-center">ایمیل</h4>
            <p class="mt10 grey lighten-5 br4 pd4 z-depth-1 text-center"><?php echo e($user->email); ?></p>
        </div>
        <div class="col-md-3">
            <h4 class="blue darken-3 white-text br4 pd4 z-depth-1 text-center">نام پدر</h4>
            <p class="mt10 grey lighten-5 br4 pd4 z-depth-1 text-center"><?php echo e($user->fatherName); ?></p>
        </div>
        <div class="col-md-3">
            <h4 class="blue darken-3 white-text br4 pd4 z-depth-1 text-center">جنسیت</h4>
            <p class="mt10 grey lighten-5 br4 pd4 z-depth-1 text-center"><?php echo e($user->genderApi); ?></p>
        </div>
        <div class="col-md-3">
            <h4 class="blue darken-3 white-text br4 pd4 z-depth-1 text-center">شهر</h4>
            <p class="mt10 grey lighten-5 br4 pd4 z-depth-1 text-center"><?php echo e((isset($user->city->title))?$user->city->title:'ثبت نشده'); ?></p>
        </div>
        <div class="clearfix mb20"></div>


        <div class="col-md-3">
            <h4 class="blue darken-3 white-text br4 pd4 z-depth-1 text-center">کد ملی</h4>
            <p class="mt10 grey lighten-5 br4 pd4 z-depth-1 text-center"><?php echo e($user->nationalCode); ?></p>
        </div>
        <div class="col-md-3">
            <h4 class="blue darken-3 white-text br4 pd4 z-depth-1 text-center">شماره شناسنامه</h4>
            <p class="mt10 grey lighten-5 br4 pd4 z-depth-1 text-center"><?php echo e($user->certificateCode); ?></p>
        </div>
        <div class="col-md-3">
            <h4 class="blue darken-3 white-text br4 pd4 z-depth-1 text-center">تاریخ تولد</h4>
            <p class="mt10 grey lighten-5 br4 pd4 z-depth-1 text-center"><?php echo e(toPersian($user->birthday)); ?></p>
        </div>
        <div class="col-md-3">
            <h4 class="blue darken-3 white-text br4 pd4 z-depth-1 text-center">محل تولد</h4>
            <p class="mt10 grey lighten-5 br4 pd4 z-depth-1 text-center"><?php echo e($user->birthplace); ?></p>
        </div>
        <div class="clearfix mb20"></div>


        <div class="col-md-3">
            <h4 class="blue darken-3 white-text br4 pd4 z-depth-1 text-center">موبایل</h4>
            <p class="mt10 grey lighten-5 br4 pd4 z-depth-1 text-center"><?php echo e($user->mobile); ?></p>
        </div>
        <div class="col-md-3">
            <h4 class="blue darken-3 white-text br4 pd4 z-depth-1 text-center">تلفن</h4>
            <p class="mt10 grey lighten-5 br4 pd4 z-depth-1 text-center"><?php echo e($user->telephone); ?></p>
        </div>
        <div class="col-md-3">
            <h4 class="blue darken-3 white-text br4 pd4 z-depth-1 text-center">کد پستی</h4>
            <p class="mt10 grey lighten-5 br4 pd4 z-depth-1 text-center"><?php echo e($user->postalCode); ?></p>
        </div>
        <div class="col-md-3">
            <h4 class="blue darken-3 white-text br4 pd4 z-depth-1 text-center">نوع کاربر</h4>
            <p class="mt10 grey lighten-5 br4 pd4 z-depth-1 text-center"><?php echo e(($user->isAdmin == 'admin')?'مدیر':'کاربر'); ?></p>
        </div>
        <div class="clearfix mb20"></div>


        <div class="col-md-12">
            <h4 class="blue darken-3 white-text br4 pd4 z-depth-1 text-center">آدرس</h4>
            <p class="mt10 grey lighten-5 br4 pd4 z-depth-1 text-center"><?php echo e($user->address); ?></p>
        </div>
        <div class="clearfix mb20"></div>


        <div class="col-md-3">
            <h4 class="blue darken-3 white-text br4 pd4 z-depth-1 text-center">مهارت</h4>
            <p class="mt10 grey lighten-5 br4 pd4 z-depth-1 text-center"><?php echo e((isset($user->skill[0]))?$user->skill[0]->title:'ثبت نشده'); ?></p>
        </div>
        <div class="col-md-3">
            <h4 class="blue darken-3 white-text br4 pd4 z-depth-1 text-center">ثبت مهارت در سامانه</h4>
            <p class="mt10 grey lighten-5 br4 pd4 z-depth-1 text-center"><?php echo e(($user->saveSkill)?'بله':'خیر'); ?></p>
        </div>
        <div class="col-md-3">
            <h4 class="blue darken-3 white-text br4 pd4 z-depth-1 text-center">آخرین مدرک تحصیلی</h4>
            <p class="mt10 grey lighten-5 br4 pd4 z-depth-1 text-center"><?php echo e($user->educationApi); ?></p>
        </div>
        <div class="col-md-3">
            <h4 class="blue darken-3 white-text br4 pd4 z-depth-1 text-center">آخرین رشته و گرایش</h4>
            <p class="mt10 grey lighten-5 br4 pd4 z-depth-1 text-center"><?php echo e($user->fieldOfStudy); ?></p>
        </div>
        <div class="clearfix mb20"></div>


        <div class="col-md-4">
            <h4 class="blue darken-3 white-text br4 pd4 z-depth-1 text-center">عکس آخرین مدرک تحصیلی</h4>
            <?php if($user->educationPicture): ?>
                <a download="<?php echo e($user->educationPicture); ?>" href="<?php echo e(asset($user->educationPicture)); ?>">
                    <img class="img-raised center-block" height="100px" src="<?php echo e(asset($user->educationPicture)); ?>" alt="">
                </a>
            <?php endif; ?>
        </div>

        <div class="col-md-4">
            <h4 class="blue darken-3 white-text br4 pd4 z-depth-1 text-center">عکس پرسنلی</h4>
            <?php if($user->personalPicture): ?>
                <a download="<?php echo e($user->personalPicture); ?>" href="<?php echo e(asset($user->personalPicture)); ?>">
                    <img class="img-raised center-block" height="100px" src="<?php echo e(asset($user->personalPicture)); ?>" alt="">
                </a>
            <?php endif; ?>
        </div>
        <div class="col-md-4">
            <h4 class="blue darken-3 white-text br4 pd4 z-depth-1 text-center">آخرین مدرک تحصیلی</h4>
            <?php if($user->nationalCardPicture): ?>
                <a download="<?php echo e($user->nationalCardPicture); ?>" href="<?php echo e(asset($user->nationalCardPicture)); ?>">
                    <img class="img-raised center-block" height="100px" src="<?php echo e(asset($user->nationalCardPicture)); ?>" alt="">
                </a>
            <?php endif; ?>
        </div>
        <div class="clearfix mb20"></div>



        <form method="post" action="<?php echo e(route('admin.users.changeStatusStore',$user->id)); ?>">
            <?php echo e(csrf_field()); ?>

            <div class="col-md-12 mb20">
                <label for="cardstatuses">انتخاب وضعیت ها</label>
                <multiselect id="cardstatuses" v-model="cardstatus.selected" :options="cardstatus.list" @search-change="search($event,'cardstatus')" :custom-label="customLabel" :multiple="true" :close-on-select="false" track-by="id" :internal-search="false">
                        <span v-if="cardstatus.list.length > 0 && isMoreResult('cardstatus')"  @click="moreResult('cardstatus')" class="waves-effect waves-light btn quarter center-block teal darken-2 mt20" slot="afterList">
                            <span v-if="cardstatus.loading"><i class="fa fa-spinner fa-pulse fa-3x fa-fw"></i></span>
                            <span v-else>موارد بیشتر</span>
                        </span>
                </multiselect>
                <?php echo $__env->make('share.forms.error',['name'=>'department_id'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>

            <div class="col-md-3 mt40">
                <?php echo $__env->make('share.forms.switch',['name'=>'canEdit','title'=>'قابل ویرایش','checked'=>$user->canEdit], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
            <div class="col-md-6 mt40">
                <?php echo $__env->make('share.forms.switch',['name'=>'isActive','title'=>'فعال','checked'=>$user->isActive], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>

            <div>
                <input type="hidden" id="cardstatus_id" name="cardstatus_id" value="<?php echo e($serviceCardStatus->pluck('id')); ?>">
            </div>


            <div class="col-md-12 mb20 mt20 ">
                <button class="waves-effect waves-light btn quarter center-block blue darken-1">ذخیره</button>
            </div>
        </form>


    </div>
<?php $__env->stopSection(); ?>


<?php $__env->startPush('scripts'); ?>
    <script src="<?php echo e(asset('assets/plugins/vueselect/vueselect.js')); ?>"></script>

    <script>
        $(document).ready(function () {
            $('select').material_select();
        });

        Vue.component('Multiselect', VueMultiselect.default);
        new Vue({
            el:'#app',
            data:{
                ax:axios.create({baseURL: baseUrl,headers:{'Authorization':'Bearer <?php echo e(auth()->user()->api_token); ?>'}}),

                cardstatus:{
                    url:'/admin/v1/service/cardstatus',
                    list:<?php echo $serviceCardStatus; ?>,
                    selected:<?php echo $serviceCardStatus; ?>,
                    query:'',
                    params:{},
                    data:[],
                    loading:false
                },
            },
            created: function () {
                this.search(null, 'cardstatus');
            },
            methods:{
                search: function (query, field, extraQuery = {}) {
                    this[field].params = extraQuery;
                    if (query) {
                        this[field].params.query = query;
                    }

                    if (query !== '' || query === null) {
                        this.ax.get(this[field].url, {params: this[field].params}).then(function (response) {
                            this[field].query = query;
                            this[field].list = response.data.data;
                            this[field].data = response.data;
                        }.bind(this));
                    }
                },
                customLabel: function (element) {
                    return element.id + ' - ' + element.title;
                },
                isMoreResult: function (field) {
                    return (this[field].data.current_page + 1 <= this[field].data.last_page);
                },
                moreResult: function (field) {
                    if (this.isMoreResult(field)) {
                        this[field].loading = true;
                        this[field].params.page = this[field].data.current_page + 1;

                        this.ax.get(this[field].url, {params: this[field].params}).then(function (response) {
                            this[field].list = this[field].list.concat(response.data.data);
                            this[field].data = response.data;
                            this[field].loading = false;
                        }.bind(this));
                    }
                }
            },
            watch:{
                'cardstatus.selected': function () {
                    var output = [];
                    for (var i = 0; i < this.cardstatus.selected.length; i++) {
                        output.push(this.cardstatus.selected[i]['id']);
                    }
                    document.getElementById('cardstatus_id').value = JSON.stringify(output);
                },
            }
        });
    </script>

<?php $__env->stopPush(); ?>

<?php $__env->startPush('styles'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('assets/plugins/vueselect/vueselect.css')); ?>">
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layout.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/vhosts/work.sheypoorchy.ir/golaren/resources/views/admin/users/changeStatus.blade.php ENDPATH**/ ?>