<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-md-12 ">
            <ol class="breadcrumb">
                <li><a href="<?php echo e(route('admin.home')); ?>">صفحه اصلی</a></li>
                <li><a href="<?php echo e(route('admin.skill.category.index')); ?>">لیست دسته بندی مهارت</a></li>
                <li class="active">ویرایش دسته بندی</li>
            </ol>
        </div>
    </div>

    <form method="post" action="<?php echo e(route('admin.skill.category.update',$skillCategory->id)); ?>">
        <?php echo e(method_field('PUT')); ?>

        <?php echo e(csrf_field()); ?>

        <div class="row white z-depth-1">
            <div class="col-md-12">
                <span class="blue-grey darken-2 white-text title z-depth-2">ویرایش دسته بندی مهارت</span>
                <?php echo $__env->make('share.extra.back2',['route'=>route('admin.skill.category.index')], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>

            <div class="col-md-12 mb20">
                <label for="skills">انتخاب مهارت ها</label>
                <multiselect id="skills" v-model="skill.selected" :options="skill.list" @search-change="search($event,'skill')" :custom-label="customLabel" :multiple="true" :close-on-select="false" track-by="id" :internal-search="false">
                        <span v-if="skill.list.length > 0 && isMoreResult('skill')"  @click="moreResult('skill')" class="waves-effect waves-light btn quarter center-block teal darken-2 mt20" slot="afterList">
                            <span v-if="skill.loading"><i class="fa fa-spinner fa-pulse fa-3x fa-fw"></i></span>
                            <span v-else>موارد بیشتر</span>
                        </span>
                </multiselect>
                <?php echo $__env->make('share.forms.error',['name'=>'admins_id'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
            <div class="col-md-6">
                <?php echo $__env->make('share.forms.input',['name'=>'title','title'=>'تیتر','value'=>$skillCategory->title], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
            <div class="col-md-6 mt30">
                <?php echo $__env->make('share.forms.switch',['name'=>'status','title'=>'فعال','checked'=>$skillCategory->status], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
            <div class="clearfix"></div>
            <div>
                <input type="hidden" id="skills_id" name="skills_id" value="<?php echo e($skillCategory->skill->pluck('id')); ?>">
            </div>



            <div class="col-md-12 mb20 mt20 ">
                <button class="waves-effect waves-light btn quarter center-block blue-grey darken-2">ذخیره</button>
            </div>

        </div>
    </form>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
    <script src="<?php echo e(asset('assets/plugins/vueselect/vueselect.js')); ?>"></script>

    <script>
        $(document).ready(function () {
            $('select').material_select();
        });

        Vue.component('Multiselect', VueMultiselect.default);
        new Vue({
            el:'#app',
            data:{
                ax:axios.create({baseURL: baseUrl,headers:{'Authorization':'Bearer <?php echo e(auth()->user()->api_token); ?>'}}),

                skill:{
                    url:'/admin/v1/skill/skill',
                    list:<?php echo $skillCategory->skill; ?>,
                    selected:<?php echo $skillCategory->skill; ?>,
                    query:'',
                    params:{},
                    data:[],
                    loading:false
                },
            },
            created: function () {
                if (this.skill.selected.length == 0) {
                    this.search(null, 'skill');
                }
            },
            methods:{
                search: function (query, field, extraQuery = {}) {
                    this[field].params = extraQuery;
                    if (query) {
                        this[field].params.query = query;
                    }

                    if (query !== '' || query === null) {
                        this.ax.get(this[field].url, {params: this[field].params}).then(function (response) {
                            this[field].query = query;
                            this[field].list = response.data.data;
                            this[field].data = response.data;
                        }.bind(this));
                    }
                },
                customLabel: function (element) {
                    return element.id + ' - ' + element.title;
                },
                isMoreResult: function (field) {
                    return (this[field].data.current_page + 1 <= this[field].data.last_page);
                },
                moreResult: function (field) {
                    if (this.isMoreResult(field)) {
                        this[field].loading = true;
                        this[field].params.page = this[field].data.current_page + 1;

                        this.ax.get(this[field].url, {params: this[field].params}).then(function (response) {
                            this[field].list = this[field].list.concat(response.data.data);
                            this[field].data = response.data;
                            this[field].loading = false;
                        }.bind(this));
                    }
                }
            },
            watch:{
                'skill.selected': function () {
                    var output = [];
                    for (var i = 0; i < this.skill.selected.length; i++) {
                        output.push(this.skill.selected[i]['id']);
                    }
                    document.getElementById('skills_id').value = JSON.stringify(output);
                },
            }
        });
    </script>

<?php $__env->stopPush(); ?>

<?php $__env->startPush('styles'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('assets/plugins/vueselect/vueselect.css')); ?>">
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layout.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/afcclub/club/resources/views/admin/Skil/category/edit.blade.php ENDPATH**/ ?>